//****************************************************************************
//
// CCfile: CptrRingpuf.cc
//
// Autor: A. Kipp
// erstellt: Fri Mar 22 08:10:58 1996 
// veraendert:
//
// Enthaelt: Einfachen Stack von Pointern mit begrenzter Anzahl von elementen.
//           wenn der Stack voll ist, wird das am wenigsten aktuelle Element
//           uberschrieben und vorher deleted, worauf der Pointer zeigt
//           Werden Elemente mit pop vom Stack geholt, wird *nichts*
//           deleted
//****************************************************************************
#include <stdlib.h>
#include <string.h>

#include "CptrRingpuf.h"

void std_destroy(void* vp);

//***************************************************************************
// Implementierung der Klasse: CptrRingpuf
// Autor: A. Kipp
// erstellt: Fri Mar 22 08:10:58 1996 
// veraendert:
//***************************************************************************
CptrRingpuf::CptrRingpuf(int anz,void (*dst)(void* dea))
{
  anzahl=anz;
  index=-1;
  nels=0;
  data = new void*[anzahl];
  memset(data,0,sizeof data);
  destroy = dst==NULL ? std_destroy : dst;
}

void CptrRingpuf::push(void* el)
{
  index = (index + 1 )%anzahl;
  nels++;
  if( nels > anzahl )
    {
      //der Ringpuffer ist voll und ein element wird ueberschrieben
      (*destroy)(data[index]);
      nels = anzahl;
    }
  data[index]=el;
}

void* CptrRingpuf::pop()
{
  void* ret;

  if( nels == 0 )
    {
      return NULL; //empty
    }
  else
    {
      ret = data[index];
      index = (index + anzahl - 1)%anzahl;
      nels--;
    }
  return ret;
}

void* CptrRingpuf::get(int i)
{

  if( i >= nels )
    {
      return NULL; //empty
    }
  else
    {
      i=(index-i+anzahl)%anzahl;
      return data[i];
    }

}

void CptrRingpuf::clear()
{
  nels=0;
}

CptrRingpuf::~CptrRingpuf()
{
  delete [] data;
}

void std_destroy(void* vp)
{
  delete vp;
}
