# This script extracts a phonetic tier from a BPF and creates the core part
# of a TextGrid file (not the header!). The input must not contain any other 
# BPF tier than the phonetic!
#
# Since MAUS creates always consecutive segments, we assume here that the 
# beginning of the next segment is the same value as the end of the 
# previous segment. This is necessary since praat has a bug that
# causes boundaries with a small deviation of end and begin time
# not to be movable.

BEGIN   {
          segcnt = 1
	  xmaxold = -1
	}  
	{
          label = $5
          for(i=6;i<=NF;i++) label = label " " $i
	  printf("        intervals [%d]:\n",segcnt)
	  if ( xmaxold != -1 ) xmin = xmaxold
	  else  xmin = $2 * 1.0 / SAMPLERATE
	  #xmax = xmin + ( ($3 + 1) * 1.0 / SAMPLERATE )
	  xmax = ($2 + $3 + 1) * 1.0 / SAMPLERATE 
	  printf("            xmin = %f\n",xmin)
	  printf("            xmax = %f\n",xmax)
	  printf("            text = \"%s\"\n",label)
	  segcnt ++
	  xmaxold = xmax
	}
