//***************************************************************************
//
// Headerfile: Cmatrix.h
//
// Autor: A.Kipp
// erstellt: veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CMATRIX
#define CMATRIX

#define CMATRIX_NOQUAD -1
#define CMATRIX_DET0 -2
#define CMATRIX_SOLVED 1


//***************************************************************************
// Klassendeklaration: Cvektor
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
// Kurzbeschreibung: selbsterklaerend
//***************************************************************************

class Cvektor
  {
  public:
  Cvektor(double* x,int dim);
  Cvektor(int dim);
  double getVal( int n) {return data[n];};
  void setVal( int n, double l) { data[n]=l;};
  void incVal( int n, double l) { data[n] += l;};
  void decVal( int n, double l) { data[n] -= l;};
  void copyVek(Cvektor* ziel);
  void clearVek();
  int dim() { return dimension;};
  ~Cvektor();

  private:
  double* data;
  int dimension;
  short mem;
  };

//***************************************************************************
// Klassendeklaration: Cmatrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
// Kurzbeschreibung: Basisklasse fuer Matrizen
//***************************************************************************

class Cmatrix
  {
  public:
  Cmatrix(Cvektor* p_row, int nr);
  Cmatrix(double* data,int nr, int nc);
  Cmatrix(int nr, int nc);
  // do-nothing-Konstruktor
  Cmatrix() : num_of_rows(0),num_of_cols(0),pp_row(NULL),mem(0){};

  double getVal(int r, int c) { return pp_row[r]->getVal(c); };
  void setVal(int r, int c, double l) { pp_row[r]->setVal(c,l); };
  void incVal(int r, int c, double l) { pp_row[r]->incVal(c,l); };
  void decVal(int r, int c, double l) { pp_row[r]->decVal(c,l); };
  void clearMat();


  void Cmatrix::printMat();
  ~Cmatrix();

  protected:
  Cvektor** pp_row;
  int num_of_rows;
  int num_of_cols;
  short mem;
  };


//***************************************************************************
// Klassendeklaration: Cquad_matrix : Cmatrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
// Kurzbeschreibung: Quadratische Matrix, Unterklasse der Matrizen
//***************************************************************************

Cquad_matrix : Cmatrix
  {
  Cquad_matrix(int dim) : Cmatrix(dim,dim) {};
  Cquad_matrix() : Cmatrix() {};
  ~Cquad_matrix(){};

  // in-place loesung: die Matrix ist nachher hin und im Inhomogenitaetsvek
  // steht die L"osung
  int solveGlsy(Cvektor* inh);
  };


//***************************************************************************
// Klassendeklaration: Csym_matrix : Cquad_matrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
// Kurzbeschreibung: Symetrische Matrix, Unterklasse der Quadratische Matrizen
//***************************************************************************

Csym_matrix : Cquad_matrix
  {
  Csym_matrix(int dim);
  double getVal(int r, int c);   
  void setVal(int r, int c, double l);
  void incVal(int r, int c, double l);
  void decVal(int r, int c, double l);
  void clearMat();                                                
  ~Csym_matrix(){};
       
  };
#endif
