//***************************************************************************
//
// Headerfile: Cheader_io.h
//
// Autor: A. Kipp
// erstellt: Wed Apr 26 10:34:11 1995 
// veraendert:
//
// Enthaelt: Allgemeine Klasse um einen Header zu parsen
// Beschreibung: die abgeleitete Klasse definiert Variablen, die aus einem
// Header zugeordnet werden sollen. diese Variablen koennen sein
// 1) c-variablen --> typ = vcvar
// 2) strings (mit blanks) --> typ=vstring
// 3) listen von strings in mehreren zeilen des Headers
// 4) Arrays/Listen/Strukturen beliebiger Datentypen
// fuer jeden der drei typen muss ein format-string definiert werden, auf
// den die einglesene Zeile matcht, wenn der Wert, der in dieser Zeile steht
// der Variablen/Listenelement zugeordnet werden soll.
// Fuer Fall 1) enthaelt der formatstring genau eine %-Anweisung (wie fuer 
// sscanf).
// in Fall 2) ein Label. taucht dieses Label am Anfang einer Zeile auf,
// wird alles danach an den uebergebenen char-Pointer kopiert. der Platz wird
// alloziiert.
// in Fall 3) ist der Formatstring eine Zahl, die die Anzahl der erforderlichen
// Parameter angibt gefolgt von einem speziellen fscanf-formatstring.
// und zwar muss mindestens die Anzahl der erforderlichen
// Parameter eine Konversionsanweisung der Form %1$[lh]{diouxefgcs} (also
// zB. fuer long int %1$ld) enthalten sein.
// passt diese Maske wird die ganze Zeile in eine Liste vom Typ Cverklist<char*>
// dupliziert.
// In Fall 4) muss neben einem Formatstring wie in Fall 3) noch eine Funktion
// definiert werden, die folgendes kann. Abhaengig vom ersten Parameter 
// -die Adresse der Zielstruktur( was auch immer ) setzen
// -aus einer Zeile die fuer die Struktur noetige Information lesen
// -die Information aus der Struktur rausschreiben
// im 2. Parameter wird beim lesen die zu scannende Zeile uebergeben, sonst NULL
// im 3. Parameter wird beim Setzen der Adresse die Adresse der Zielstruktur
// uebergeben.
// im 4. Parameter ein FILE* (lesen,schreiben)
// 
// Beispiel: siehe Cmyheader_io.cc
//
//***************************************************************************
#ifndef CHEADERIO
#define CHEADERIO

#include "Cfile_io.h"
#include "Cverklist.h"
#include <string.h>
#include <stdlib.h>

#define READ_ERR -13

class Cheader_io;

typedef enum {vcvar,vstring,vstringlist,vlist} v_type;

typedef enum {readf,writef} frw_cntl;

typedef int (*frwfunc)(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp);

struct vardef
  {
  vardef() {hit=0;};
  char* mask; //wenn diesese Maske mit sscanf matcht wird zugeordnet
  v_type typ;
  union addrtyp{
        void* addr;
        char** cpp;
        Cverklist<char*>* vclist;
        frwfunc frw;
        }atyp;
  int hit;
  int rqd;
  };

#define ENDMARKER "##end:"
#define COMMENTMARKER "//"

//***************************************************************************
// Klassendeklaration: class Cheader_io
//
// Autor: A. Kipp
// erstellt: Wed Apr 26 10:34:11 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
class Cheader_io : public Cfile_io
  {
  public:
  Cheader_io() {endmarker=strdup(ENDMARKER);lines=0;err=0;erritem=-1;
                commentmarker=strdup(COMMENTMARKER);};
  int readFile();
  int writeFile();
  void specCvar(char* format,void* addr,int rqd);
  void specString(char* format,char** cpp,int rqd);
  void specClist(char* format,Cverklist<char*>* vclist,int rqd);
  void specList(char* format,frwfunc frw,void* addr,int rqd);
  
  void setEndMark(char* em) { free((char*)endmarker) ; endmarker=strdup(em);};
  
  protected:
  char* endmarker;
  char* commentmarker;
  Cverklist<vardef> vardeflist;
  int lines;
  int err;
  int erritem;
  };

#endif
