# check input BPF for impossible short chunks
# see maus.trn for details
#
# in case that an impossible short chunk is found, the script 
# prints the start sample of that chunk to stdout and exits with 
# error code 1; otherwise no output is produced and exit code is 0
#
# call this script with option -v RATE=<samplerate>
# this script works only when the TRN tier appears after the KAN tier
# otherwise no impossible short chunks are found

/^KAN:/ {
	ps = $3
	gsub(/[:_P'"<>]/,"",ps)
	kanlen[$2] = length(ps)
#print "kanlen[" $2 "] : " kanlen[$2]
}
/^TRN:/ {
	trnsamdur = $3
	split($4,kanlnks,",")
        kanl = 0
        for(idx in kanlnks){
		kanl += kanlen[kanlnks[idx]] 
	}
        # assume that each phon has minimum HMM length of 30msec (3 frames)
	kanlsamdurmin = int(kanl*RATE/34)
#print $0
#print "trnsamdur = " trnsamdur ", kanlsamdurmin = " kanlsamdurmin
	if(kanlsamdurmin > trnsamdur) {
          print $2
          exit 1
        }
}
