h57360
s 00088/00000/00020
d D 1.2 96/05/09 16:04:07 kip 2 1
c erste Version
c 
e
s 00020/00000/00000
d D 1.1 96/05/09 13:10:40 kip 1 0
c 
e
u
U
f b 
f e 0
t
T
I 1
//****************************************************************************
//
// CCfile: Cpsout.cc
//
// Autor: A. Kipp
// erstellt: Thu May  9 11:48:35 1996 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
I 2
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
E 2

#include "Cpsout.h"
#include "CCexceptions.h"

//***************************************************************************
// Implementierung der Klasse: Cpsout
// Autor: A. Kipp
// erstellt: Thu May  9 11:48:35 1996 
// veraendert:
//***************************************************************************
I 2
Cpsout::Cpsout(char* crea = NULL,char* dt = NULL)
{
  if( (pslibpath = getenv("PSLIBPATH")) == NULL )
    {
      pslibpath = strdup(".");
    }
  else
    {
      pslibpath = strdup(pslibpath);
    }

  if( (tmpf=fopen(PSTMP,"w"))== NULL )
    {
      failure(__FILE__,__LINE__,"Unable to open temporary File %s",
	      PSTMP);
    }
  out = NULL;
  date = dt==NULL ? strdup("now") : strdup(dt);
  creator = crea==NULL ? strdup("unknown") : strdup(crea);
}

int Cpsout::writeFile(char* filename,int nofpages)
{
  char buf[200];
  int readbytes;

  if( (out=fopen(filename,"w")) == NULL )
    {
      warning(__FILE__,__LINE__,"Error opening %s",filename);
    }

  if( (tmpf=freopen(PSTMP,"r",tmpf)) == NULL )
    {
      failure(__FILE__,__LINE__,"Cannot read from %s",PSTMP);
    }

  //write Header
  fprintf(out,"%%!PS-Adobe-2\n%%%%Creator: %s\n%%%%Date: %s\n",creator,date);
  if( nofpages > 0 )
    {
      fprintf(out,"%%%%Pages: %d\n",nofpages);
      fprintf(out,"%%%%PageOrder: Ascend\n");
    }

  while( (readbytes=fread(buf,1,200,tmpf)) > 0 )
    {
      fwrite(buf,1,readbytes,out);
    }
  fprintf(out,"%%%%EOF\n");
  if( (tmpf=freopen(PSTMP,"w",tmpf)) == NULL )
    {
      failure(__FILE__,__LINE__,"Cannot read from %s",PSTMP);
    }
}

int Cpsout::need(char* psfilename)
{
  FILE* needfp;
  char filename[200],buf[200];
  int readbytes;

  sprintf(filename,"%s/%s.ps",pslibpath,psfilename);

  if( (needfp=fopen(filename,"r")) == NULL )
    {
      warning(__FILE__,__LINE__,"Error reading needed file %s",filename);
      return -1;
    }

  fprintf(tmpf,"%%%% Start %s\n",psfilename);
  while( (readbytes=fread(buf,1,200,needfp)) > 0 )
    {
      fwrite(buf,1,readbytes,tmpf);
    }
  fprintf(tmpf,"%%%% End %s\n",psfilename);
  fclose(needfp);
  return 1;
}

Cpsout::~Cpsout()
{
  free(pslibpath);
  fclose(tmpf);
  unlink(PSTMP);
}
E 2
E 1
