//****************************************************************************
//
// CCfile: Cgraph.cc
//
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include <stdio.h>
#include <string.h>
#include "Cgraph.h"
#include "CCexceptions.h"

extern "C" {
char *strtok_r(char *s1, const char *s2, char **lasts);
	   }

#define NODEID "I="
#define EDGEID "J="
#define SIZEID "N="

//***************************************************************************
// Implementierung der Klasse: Cgraph
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
//***************************************************************************
Cgraph::Cgraph()
  {
  comp = 0;
  nnodenr=0;
  specnodes = -1;
  specedges = -1;
  }
  
 
Cnode* Cgraph::addNode(Cnode* nd)
  {
  int i;
  Cnode** ndptrptr;
  
  if( nd == NULL )
    {
    nd = newNode();
    }
    
  if( nd->nodenr == -1 ) // selber Knotennummer suchen
    {
    nd->nodenr = nnodenr;
    comp = comp == nnodenr ? comp+1 : (-1);
    }
  else
    {
    for( ndptrptr=nodes.skipThru(init) ; ndptrptr != NULL ; 
         ndptrptr=nodes.skipThru(next) )
      {
      if( (*ndptrptr)->nodenr == nd->nodenr )
        {
        return NULL;
        }      
      }
      
    if( nnodenr < nd->nodenr )
        {
        nnodenr = nd->nodenr;
        }
    comp = -1;
    }
      
  nodes.addEl(&nd);
  nnodenr++;
  return nd;
  }
  
 
Cedge* Cgraph::addEdge(Cedge* ed,Cnode* begn,Cnode* endn)
 {
 int i;
 Cnode **tmp;
 Clistel<Cnode*> *skipvar;
 
 //suche Anfangsknoten;
 if( ed==NULL )
   {
   ed=newEdge();
   ed->startnode = begn;
   ed->endnode = endn;
   }
 else
   {
     if( begn == NULL )
       {
	 begn = ed->startnode;
       }
     if( endn == NULL )
       {
	 endn = ed->endnode;
       }
   }
   
 for( tmp=nodes.skipThru(init,&skipvar); 
        !(tmp == NULL || ( begn != NULL && endn != NULL ) ); 
        tmp=nodes.skipThru(next,&skipvar) )
   {
   if( (*tmp) == ed->startnode )
     {
     begn=*tmp;
     }
   if( *tmp == ed->endnode )
     {
     endn=*tmp;
     }
   }
   
   
 if( endn == NULL || begn == NULL )
   {
   return NULL;
   }
 
 edges.addEl(&ed); 
 //Nachfolger/Vorgaenger Verzeigern
 endn->predecs.addEl(&ed);
 begn->succs.addEl(&ed);
 return ed; 
 }

Cedge* Cgraph::isIn(Cnode* begn,Cnode* endn)
{
  int i;
  Cedge **edptrptr;
  Clistel<Cedge*> *skipvar;
  
  for( edptrptr=begn->succs.skipThru(init,&skipvar) ;
       edptrptr != NULL ;
       edptrptr=begn->succs.skipThru(next,&skipvar) )
    {
      if( (*edptrptr)->endnode == endn )
	{
	  return *edptrptr;
	}
    }
  return NULL;
}

Cnode* Cgraph::newNode()
  {
  return new Cnode;
  }
  
Cedge* Cgraph::newEdge()
  {
  return new Cedge;
  }
  
int Cgraph::readGraph(FILE* fp)
  {
    clear();
    //process key=value list
    char line[200];
    enum entrytype { size_entry,node_entry,edge_entry} etype;
    Cnode* ndptr;
    Cedge* edptr;

    while( fgets(line,200,fp) != NULL )
      {
	if( line[0] == '#' )
	  {
	    continue;
	  }

	if( strstr(line,SIZEID) )
	  {
	    etype = size_entry;
	    clear();
	  }
	else if(strstr(line,EDGEID) )
	  {
	    etype = edge_entry ;
	    edptr = newEdge();
	  }
	else if( strstr(line,NODEID) )
	  {
	    etype = node_entry;
	    ndptr = newNode();
	  }
	else
	  {
	    continue;
	  }
	char *outer;
	char *inner;
	char *kvpair;
	char *kp,*vp;
	char key[50],value[100];
	for( kvpair=strtok_r(line," \t,",&outer) ; kvpair != NULL;
	     kvpair=strtok_r(NULL," \t,",&outer) )
	  {
	    kp = strtok_r(kvpair,"=",&inner);
	    if( kp == NULL )
	      {
		continue;
	      }
	    sscanf(kp,"%s",key);
	    vp = strtok_r(NULL,"=",&inner);
	    if( vp == NULL )
	      {
		continue;
	      }
	    sscanf(vp,"%s",value);
	    switch( etype )
	      {
	      case size_entry:
		setSize(key,value);
		break;
	      case node_entry:
		setNode(ndptr,key,value);
		break;
	      case edge_entry:
		setEdge(edptr,key,value);
	      }
	  }
	switch( etype )
	  {
	  case node_entry:
	    if( addNode(ndptr) == NULL )
	      {
		failure(__FILE__,__LINE__,"error setting node with line %s",
			line);
	      }
	    break;
	  case edge_entry:
	    if( addEdge(edptr) == NULL )
	      {
		failure(__FILE__,__LINE__,"error setting edge with line %s",
			line);
	      }
	  }
      }
    if( nodes.getAnzel() != specnodes )
      {
	failure(__FILE__,__LINE__,"%d nodes specified but %d nodes read",
		specnodes,nodes.getAnzel());
      }
    if( edges.getAnzel() != specedges )
      {
	failure(__FILE__,__LINE__,"%d edges specified but %d nodes read",
		specedges,edges.getAnzel());
      }
	 
  return 1;   
	    
  }

void Cgraph::writeGraph(FILE* fp)
  {
  Cedge **edptrptr;
  Clistel<Cedge*> *edskip;
  Cnode **ndptrptr;
  Clistel<Cnode*> *ndskip;
  int i;
  char line[200];
  
  fprintf(fp,SIZEMASK,nodes.getAnzel(),edges.getAnzel());
  fprintf(fp,NODELISTSTART);
  for(  ndptrptr=nodes.skipThru(init,&ndskip) ; ndptrptr != NULL ;
       ndptrptr=nodes.skipThru(next,&ndskip) )
    {
    fprintf(fp,NODEMASK,(*ndptrptr)->nodenr);
    putNodeInfo(*ndptrptr,line);
    fprintf(fp,line);
    putc('\n',fp);
    }
  
  fprintf(fp,NODELISTEND);
  fprintf(fp,EDGELISTSTART);
     
  for( edptrptr=edges.skipThru(init,&edskip) , i=0; 
       edptrptr!=NULL ;
       edptrptr=edges.skipThru(next,&edskip),i++ )
    {
    fprintf(fp,EDGEMASK,i);
    putEdgeInfo(*edptrptr,line);
    fprintf(fp,line);
    putc('\n',fp);
    }
    
  fprintf(fp,EDGELISTEND);
  }

int Cgraph::setNode(Cnode* ndptr,char* key,char* value)
{
  if( !strcmp(key,"I") )
    {
      ndptr->nodenr = atoi(value);
    }
}

int Cgraph::setEdge(Cedge* edptr,char* key,char* value)
{
  if( !strcmp("S",key) )
    {
      edptr->startnode = getNodeNr( atoi(value) );
    }
  else if( !strcmp("E",key) )
    {
      edptr->endnode = getNodeNr( atoi(value) );
    }
}

void Cgraph::setSize(char* key,char* value)
{
  if( !strcmp("N",key) )
    {
      specnodes = atoi(value);
    }
  else if( !strcmp("L",key) )
    {
      specedges = atoi(value) ;
    }
}  

char* Cgraph::putNodeInfo(Cnode* ndptr,char* target)
{
  return target;
}

char* Cgraph::putEdgeInfo(Cedge* edptr,char* target)
{
  char kvp[100];
  sprintf(kvp,"S=%d E=%d",edptr->startnode->nodenr,edptr->endnode->nodenr);
  sprintf(target," %s",kvp);
  target += strlen(kvp)+1;
  return target;
}

void Cgraph::delNode(int nodenr)
  {
  delNode(getNodeNr(nodenr));
  }
   
void Cgraph::delNode(Cnode* ndptr,Cnode*** succlist,int* nsuccs,
                     Cnode*** predlist,int* npreds)
  {
  Cedge **edptrptr;
  Clistel<Cedge*> *edskip;
  Cnode **ndptrptr;
  Clistel<Cnode*> *ndskip;
  Cverklist<Cnode*> succnodes;
  Cverklist<Cnode*> prednodes;
  int i;
  
  
  //alle inzidenten Kanten killen
  //alle Nachfolger suchen
  for( i=0 , edptrptr=ndptr->succs.skipThru(init,&edskip) ; edptrptr!=NULL ; 
       edptrptr=ndptr->succs.skipThru(next,&edskip) ,i++)
    {
    succnodes.addEl(&((*edptrptr)->endnode));
    }
  
  if( nsuccs !=NULL && succlist!=NULL )
    {
    *nsuccs = succnodes.compact( succlist);
    }
    
  //alle Kanten, die den zu deletenden Knoten als Vorgaenger haben
  //killen
  for( ndptrptr=succnodes.skipThru(init) ; ndptrptr != NULL ;
       ndptrptr=succnodes.skipThru(next) )
    {
    for( i=0 , edptrptr=(*ndptrptr)->predecs.skipThru(init,&edskip) ; 
         i<(*ndptrptr)->predecs.getAnzel() ;)
      {
      if( (*edptrptr)->startnode == ndptr )
        {
        (*ndptrptr)->predecs.delElIndx(i);
        }
      else
        {
        edptrptr=(*ndptrptr)->predecs.skipThru(next,&edskip);
        i++;
        }
      }
    }
  
  //Alle Vorgaenger suchen  
  for( i=0 , edptrptr=ndptr->predecs.skipThru(init,&edskip) ; edptrptr!=NULL ; 
       edptrptr=ndptr->predecs.skipThru(next,&edskip) ,i++)
    {
    prednodes.addEl(&((*edptrptr)->startnode));
    }

  if( npreds !=NULL && predlist!=NULL )
    {
    *npreds = prednodes.compact( predlist);
    }
    
  //Alle, die den zu deletenden Knoten als Nachfolger haben, killen  
  for( ndptrptr=prednodes.skipThru(init) ; ndptrptr != NULL ;
       ndptrptr=prednodes.skipThru(next) )
    {
    for( i=0 , edptrptr=(*ndptrptr)->succs.skipThru(init,&edskip) ; 
               i<(*ndptrptr)->succs.getAnzel() ;)
      {
      if( (*edptrptr)->endnode == ndptr )
        {
        (*ndptrptr)->succs.delElIndx(i);
        }
      else
        { 
        edptrptr=(*ndptrptr)->succs.skipThru(next,&edskip);
        i++;
        }
      }
    }

  //inzidende Kanten aus der Kantenliste streichen
  for( i=0 , edptrptr=edges.skipThru(init,&edskip) ; i<edges.getAnzel() ; )
    {
    if( (*edptrptr)->startnode == ndptr || (*edptrptr)->endnode == ndptr )
      {
      delete *edptrptr;
      edges.delElIndx(i);
      }
    else
      {
      edptrptr=edges.skipThru(next,&edskip);
      i++;
      }
    }
      
  for( i=0 , ndptrptr=nodes.skipThru(init,&ndskip) ; ndptrptr != NULL ;
       ndptrptr=nodes.skipThru(next,&ndskip),i++ )
    {
    if( *ndptrptr == ndptr )
      {
      nodes.delElIndx(i);
      break;
      }
    }
  
  delete ndptr;  
  comp=-1;
  }

  
 
Cnode* Cgraph::getNodeNr(int nodenr)
  {
  int i;
  Cnode** ndptrptr;
  
  for( ndptrptr=nodes.skipThru(init) ; 
       ndptrptr != NULL && (*ndptrptr)->nodenr != nodenr ; 
       ndptrptr= nodes.skipThru(next) );
  return ndptrptr != NULL ? *ndptrptr : NULL;
  }


 
void Cgraph::delEdge(Cedge *edptr)
  {
  int i;
  Cedge **edptrptr;
  Cnode *ndptr;
  
  //aus der Nachfolgerliste des Startknotens streichen
  for( i=0 , edptrptr=edptr->startnode->succs.skipThru(init) ; edptrptr!=NULL ;)
    {
    if( *edptrptr==edptr )
      {
      edptr->startnode->succs.delElIndx(i);
      break;
      }
    else
      { 
      edptrptr=edptr->startnode->succs.skipThru(next);
      i++;
      }
    }

  //aus der Vorgaengerliste des Endknotens streichen
  for( i=0 , edptrptr=edptr->endnode->predecs.skipThru(init) ; edptrptr!=NULL ;)
    {
    if( *edptrptr==edptr )
      {
      edptr->endnode->predecs.delElIndx(i);
      break;
      }
    else
      { 
      edptrptr=edptr->endnode->predecs.skipThru(next);
      i++;
      }
    }
    
  //aus der Kantenliste
  for( i=0 , edptrptr=edges.skipThru(init) ; edptrptr!=NULL ;
       edptrptr=edges.skipThru(next),i++)
    {
    if( *edptrptr==edptr )
      {
      edges.delElIndx(i);
      break;
      }
    }
  
  delete edptr;
  }  
 
void Cgraph::compact()
  {
  Cedge **edptrptr;
  Cnode **ndptrptr;
  int i;
  
  for( i=0, ndptrptr=nodes.skipThru(init) ; 
       ndptrptr != NULL ; 
       ndptrptr= nodes.skipThru(next) , i++)
    {
      (*ndptrptr)->nodenr =i;
    }
    
  comp = i;
  nnodenr=i;
  }

int Cgraph::getRanks()
  {
  Cedge **edptrptr;
  int i;
  int rank;
  int done=0;
  char found;
  Cnode** ndlist;
  int ndanz;
  
  compact();
  ndanz = nodes.compact(&ndlist);
  
  int *npredlist = new int[ndanz]; //<-wird nicht richtig initialisiert!!!
  
  for( i=0 ; i<ndanz ; i++ )
    {
    npredlist[i]=ndlist[i]->predecs.getAnzel();
    ndlist[i]->rank = -1;
    }
    
  for( maxrank=0 ; done<ndanz ; maxrank++ )
    {
    found=0;
    for( i=0 ; i<ndanz ; i++ )
      {
      if( npredlist[i] == 0)
        {
        ndlist[i]->rank = maxrank;
        npredlist[i]--;
        done++;
        found++;
        }
      }
    
    if( !found )
      {
      return -4;
      }
      
    //Vorgaengeranzahl dekrementieren
    for( i=0 ; i<ndanz ; i++ )
      {
      if( ndlist[i]->rank == maxrank)
        {
        for( edptrptr=ndlist[i]->succs.skipThru(init) ; 
             edptrptr!=NULL ; edptrptr=ndlist[i]->succs.skipThru(next) )
          {
          npredlist[(*edptrptr)->endnode->nodenr]--;
          }
        npredlist[i]=-1;
        }
      }
    }
 
  delete [] npredlist;
  delete [] ndlist;
  
  return --maxrank;
  }
  
 
void Cgraph::clear()
  {
  Cedge** edptrptr;
  Cnode** ndptrptr;
  
  for( edptrptr=edges.skipThru(init) ; edptrptr!=NULL ; 
  edptrptr=edges.skipThru(next) )
    {
    delete *edptrptr;
    }
      
  for( ndptrptr=nodes.skipThru(init) ; ndptrptr != NULL ;
       ndptrptr=nodes.skipThru(next) )
    {
    delete *ndptrptr;
    }
    
  nodes.clear();
  edges.clear();
  comp = 0;
  nnodenr=0;
  }

 
Cgraph::~Cgraph()
  {
  clear();
  }

int compranks(const void* p1,const void* p2)
{
  return (*(Cnode**)p1)->rank-(*(Cnode**)p2)->rank;
}
