//****************************************************************************
//
// CCfile: Csegment_io.cc
//
// Autor: A. Kipp
// erstellt: Wed Apr 26 10:15:11 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "Csegment_io.h"
#include "CCexceptions.h"

int slist_frw(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp);
  
//***************************************************************************
// Implementierung der Klasse: Csegment_io
// Autor: A. Kipp
// erstellt: Wed Apr 26 10:15:11 1995 
// veraendert:
//***************************************************************************
Csegment_io::Csegment_io(char* filenam,int fbr,int fver,char* crea,char* info)
  {
  framebreite = fbr;
  frameverschiebung = fver;
  addinfo=info;
  creator=crea;
  filename=filenam;
  recIt();
  }

Csegment_io::Csegment_io()
  {
  framebreite = 0;
  frameverschiebung = 0;
  addinfo="none";
  creator=NULL;
  filename=NULL;
  recIt();
  } 

void Csegment_io::recIt()
  {
  //vardeflist erstellen
  specCvar("framebreite=%d",&framebreite,1);
  specCvar("frameverschiebung=%d",&frameverschiebung,1);
  specString("filename=",&filename,1);
  specString("creator: ",&creator,1);
  specString("addinfo: ",&addinfo,0);
  specList("3%1$d %1$d %1$s",slist_frw,this,1);
  }

void Csegment_io::clear()
  {
  segment_rec** srpp;
  
  for( srpp = slist.skipThru(init) ; srpp!=NULL ; srpp=slist.skipThru(next))
    {
      if( (*srpp)->addinfo != NULL )
	{
	  free( (*srpp)->addinfo );
	}
	    
      if( (*srpp)->symbol != NULL )
	{
	  free( (*srpp)->symbol );
	}
    delete *srpp;
    }
    
  slist.clear();
  }
  
void Csegment_io::setFilename(char* filenam)
  {
  filename=filenam;
  }
   
  
int slist_frw(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp)
  {
  Cverklist<segment_rec*>* slistptr;
  segment_rec **srptrptr,*srptr;
  char label[20];
  int nc;
  char *cp;
  slistptr = &(((Csegment_io*)addr)->slist);
  
  switch(cntl)
    {
    case readf:
      srptr = new segment_rec;
      if( sscanf(line,"%d %d %s%n",&srptr->start,&srptr->end,label,&nc) != 3 )
        {
        return -1;
        delete srptr;
        }
      srptr->symbol = strdup(label);
      if( ( cp=strchr(line,'\n')) != NULL )
	{
	  *cp = '\0';
	}
      cp = line + nc + strspn(line + nc," \t");
      srptr->addinfo = *cp == '\0' ? NULL : strdup(cp);
      slistptr->addEl(&srptr);
      return 1;
      
    case writef:
      for( srptrptr=slistptr->skipThru(init) ; srptrptr != NULL ; 
           srptrptr=slistptr->skipThru(next) )
        {
        fprintf(fp,"%d %d %s %s\n",(*srptrptr)->start, (*srptrptr)->end,
                 (*srptrptr)->symbol,
                 (*srptrptr)->addinfo == NULL ? "" : (*srptrptr)->addinfo);
        }
      return 1;
    }
  }
        
