//****************************************************************************
//
// CCfile: Cquad_matrix.cc
//
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//
// Enthaelt:
//****************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Cquad_matrix.h"


//***************************************************************************
// Implementierung der Klasse: Cquad_matrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

Cquad_matrix::Cquad_matrix(Cmatrix& mat) : Cmatrix(mat)
  {
  if( num_of_rows != num_of_cols )
    {
    num_of_rows=0;
    num_of_cols=0;

    if( mem )
      {
      delete [] data;
      mem=0;
      }
    }
  err=0;
  }
  
Cvektor Cquad_matrix::solveGlsy(Cvektor* inhomog)
  {
  int r,rr,c,i,pivrow;
  double pivel,colel,el,max;
  Cvektor* tmp;

  Cquad_matrix tmpmat( *this );
  Cvektor inh(*inhomog);

  for( r=0 ; r<tmpmat.num_of_rows ; r++ )
    {
    // Pivotsuche
    max=0.0;
    for( rr=r ; rr < tmpmat.num_of_rows ; rr++ )
      {
      if( (el=fabs( tmpmat.getVal(rr,r) ) ) > max )
        {
        max=el;
        pivrow=rr;
        }
      }

    if( max == 0.0 )
      {
      inh.clearVek();
      err=(-1)*r;
      return inh;
      }
    pivel=tmpmat.getVal(pivrow,r);

    // tauschen
    tmp = tmpmat.pp_row[r];
    tmpmat.pp_row[r] = tmpmat.pp_row[pivrow];
    tmpmat.pp_row[pivrow] = tmp;

    // inhomogenitaet
    el=inh.getVal(r);
    inh.setVal(r,inh.getVal(pivrow));
    inh.setVal(pivrow,el);

    for( rr=0 ; rr<tmpmat.num_of_rows ; rr++ )
      {
      if( rr == r )
        {
        continue;
        }

      // zeilentranf
      colel=tmpmat.getVal(rr,r);
      for( c=r ; c<num_of_cols ; c++)
        {
        tmpmat.decVal(rr,c,(colel/pivel)*tmpmat.getVal(r,c));
        }
      // inhomogenitaet
      inh.decVal(rr,(colel/pivel)*inh.getVal(r) );
      }

    } // for r

  for( c=0 ; c<tmpmat.num_of_cols ; c++)
    {
    colel=inh.getVal(c);
    inh.setVal(c,colel/tmpmat.getVal(c,c));
    }
 
  err = 0; 
  return inh;
  }


Cquad_matrix& Cquad_matrix::operator=( Cquad_matrix& mat) 
  {
  int i;

  if( num_of_cols != mat.num_of_cols )
    {
    fprintf(stderr,"Matrices must have equal dimensions\n");
    exit(1);
    }

    
  for( i=0 ; i<num_of_rows ; i++ )
    {
    memcpy(data+i*num_of_cols,mat.pp_row[i]->data,num_of_cols*sizeof(double));
    pp_row[i]->data = data+i*num_of_cols;
    }

  
  return *this;  
  }
