//****************************************************************************
//
// CCfile: Cringpuf.cc
//
// Autor: A. Kipp
// erstellt: Thu Mar 21 14:57:48 1996 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include <stdio.h>
#include "Cringpuf.h"
#include <string.h>
//#include "CCexceptions.h"

//***************************************************************************
// Implementierung der Klasse: Cringpuf
// Autor: A. Kipp
// erstellt: Thu Mar 21 14:57:48 1996 
// veraendert:
//***************************************************************************
Cringpuf::Cringpuf(int anz,int sz)
{
  size =sz;
  anzahl=anz;
  index=-1;
  nels=0;
  data = new char[anzahl*size];
}

void Cringpuf::push(void* el)
{
  index = (index + 1 )%anzahl;
  nels = nels == anzahl ? nels : nels+1;
  memcpy(data + index*size,el,size);
}

void* Cringpuf::pop()
{
  char* ret;

  if( nels == 0 )
    {
      return NULL; //empty
    }
  else
    {
      ret = new char[size];
      memcpy(ret,data + index*size,size);
      index = (index + anzahl - 1)%anzahl;
      nels--;
    }
  return (void*)ret;
}

void* Cringpuf::get(int i)
{
  char* ret;

  if( i >= nels )
    {
      return NULL; //empty
    }
  else
    {
      i=(index-i+anzahl)%anzahl;
      ret = new char[size];
      memcpy(ret,data + i*size,size);
    }
  return (void*)ret;
}

void Cringpuf::clear()
{
  nels=0;
}

Cringpuf::~Cringpuf()
{
  delete [] data;
}
