//****************************************************************************
//
// CCfile: CrlkontWordVar.cc
//
// Autor: A. Kipp
// erstellt: Fri Jan 3 11:46:50 MET 1997
// veraendert:
//
// Enthaelt:
//***************************************************************************
#include <math.h>
#include "CrlkontWordVar.h"
#include "CCexceptions.h"

int cmpcsplit(const void* p1,const void* p2);

struct rapplrec
{
  int next;
  Cnode* nd;
  Cverklist<ruleappl*> rappls;
};

//***************************************************************************
// Implementierung der Klasse: CrlkontWordVar
// Autor: A. Kipp
// erstellt: Fri Jan 3 11:46:50 MET 1997 
// veraendert:
//***************************************************************************
CrlkontWordVar::CrlkontWordVar()
{
}

int CrlkontWordVar::readRegeln(char* regelfilename)
{
  int k;
  int a = CwordVar::readRegeln(regelfilename);
  for( k=0 ; k<regelanz ; k++ )
    { 
      if( regellist[k]->inident == 0 || 
	  regellist[k]->endident == 0 )
	{
	  char rul[50];
	  regellist[k]->verbatim(rul);
	  warning(__FILE__,__LINE__,"error in rule %d (%s), discarding\n",
		  k,rul);
	  delete regellist[k];
	  regellist[k]=NULL;
	  continue;
	}
    }
  return a;
}

void CrlkontWordVar::applyRules() 
{
  int i,j,jj,k,l;
  Cvgrnode* vgrnode;
  Cvgredge* vgredge;
  Cnode* nd;
  Cedge* edptr,**edptrptr;
  ruleappl* arapl,**rapp;
  Cverklist<ruleappl*> raplist,allraplist;
  double sumwk;
  
  
  for( i=0 ; i<vtrndanz ; i++ )
    {
      vgrnode = (Cvgrnode*)ndlist[i];
      vtrrecndlist[i].vgrndp = vgrnode;
    }

  for( i=0 ; i<vtrndanz ; i++ )
    {
      vgrnode = (Cvgrnode*)ndlist[i];
      
      for( k=0 ; k<regelanz ; k++ )
	{ 
	  if( regellist[k] == NULL ) 
	    {
	      continue;
	    }
	  for( j=i ; j < vtrndanz  && 
		 (j-i) < regellist[k]->lsanz &&
		 ((Cvgrnode*)ndlist[j])->symbol ==
		 regellist[k]->ls[j-i] ; j++ );

	  if( (j-i) == regellist[k]->lsanz )
	    {
	      //match!!
	      arapl = new ruleappl;
	      arapl->therule = regellist[k];
	      arapl->sind = i;
	      arapl->eind = j-1;
	      vtrrecndlist[i].rapplstarts.addEl(&arapl);
	      allraplist.addEl(&arapl);
	      for( jj=i ; jj<j ; jj++ )
		{
		  vtrrecndlist[jj].rappls.addEl(&arapl);
		}
	      firstPass( arapl );
	      if( arapl->csplit < 0 )
		{
		  failure(__FILE__,__LINE__,"not rl-kontext-rule %d",
			  arapl->therule->rulenr);
		}
	      
	    } 
	}
    }

  allrapanz = allraplist.compact(&allrap);
  allraplist.clear();
  ruleappl *rap;
  vtrnoderec* vtr;
  for( i=0 ; i<vtrndanz ; i++ )
    {
      vtr = vtrrecndlist + i;
      //compact
      vtr->rpanz = 
	vtr->rappls.compact(&vtr->rp);
      vtr->rpsanz = 
	vtr->rapplstarts.compact(&vtr->rps);

    }

  //sort for rising csplits
  qsort(allrap,allrapanz,sizeof(ruleappl*),cmpcsplit);
  rapplrec* rrec = new rapplrec[allrapanz];
  int nrr;

  //abuse for scoring rules
  Chgraph rulegraph;
  rulegraph.filename = strdup("rg");

  for( i=0,nrr=0 ; i<allrapanz ; nrr++ )
    {
      rrec[nrr].nd = rulegraph.addNode();
      //just for debug
      char line[50];
      allrap[i]->therule->verbatim(line);
      ((Chgrnode*)rrec[nrr].nd)->symbol = strdup(line);
      //aequivalent class
      rrec[nrr].rappls.addEl(allrap + i);
      for( i++; i<allrapanz && sameContext(allrap[i],allrap[i-1]) ; i++)
	{
	  rrec[nrr].rappls.addEl(allrap + i);
	}
    }
   
  for( i=0 ; i<nrr ; i++ )
    {
      for( j=i ; j<nrr && 
	     rrec[j].rappls[0]->csplit < 
	     rrec[i].rappls[0]->crecom + 
	     rrec[i].rappls[0]->therule->endident -1 ; j++ );
      //naechster rekombinationsknoten
      int nrecom ;
      for( nrecom = vtrndanz ; 
	   j<nrr && rrec[j].rappls[0]->csplit < nrecom ; 
	   j++)
	{
	  if( rrec[j].rappls[0]->crecom < nrecom )
	    {
	      nrecom = rrec[j].rappls[0]->crecom;
	    }
	  rulegraph.addEdge(NULL,rrec[i].nd,rrec[j].nd);
	}
    }

  rulegraph.scoreEdges();
  //rulegraph.writeHGraph();
  ruleappl** rrpp;
  for( i=0 ; i<nrr ; i++ )
    {
      char line[50];
      for( rrpp=rrec[i].rappls.skipThru(init);
	   rrpp != NULL ;
	   rrpp=rrec[i].rappls.skipThru(next))
	{
	  (*rrpp)->rapwk = rrec[i].nd->log_wkt + (*rrpp)->therule->cellwk
	+ (*rrpp)->therule->ruleweight;
	  (*rrpp)->therule->verbatim(line);
	  //printf("%d: %s %lf %lf (split=%d recomb=%d\n",i,line,(*rrpp)->rapwk,
	  //(*rrpp)->therule->ruleweight,(*rrpp)->csplit,(*rrpp)->crecom);
	}
    }
  //rulegraph.clear();

  int csplakt=0;
  Cvgrnode* csptr;
  for( i=0 ; i<allrapanz ; i++ )
    {
      csplakt = allrap[i]->csplit;
      csptr = vtrrecndlist[csplakt].vgrndp;
      //score inner edge
      if( !(edptr=vargraph->isIn(csptr,allrap[i]->rentry) ) ||
	  allrap[i]->rapwk > csptr->log_wkt )
	{
	  failure(__FILE__,__LINE__,
		  "internal error at node %d rapwk=%lf cswk=%lf\n edge: %c",
		  csptr->nodenr,
		  allrap[i]->rapwk,csptr->log_wkt,
		  edptr==NULL ? 'n' : 'j');
	}
      ((Chgredge*)edptr)->rulenumber = allrap[i]->therule->rulenr;

      //for wordnos
      int nwn;
      for( nwn=allrap[i]->csplit ; 
	   strpbrk(vtrrecndlist[nwn].vgrndp->symbol,"#") &&
	     nwn < vtrndanz;
	   nwn++);

      ((Cvgredge*)edptr)->log_uewkt = allrap[i]->rapwk - csptr->log_wkt;
      for( ; edptr->endnode != 
	     vtrrecndlist[allrap[i]->eind - 
			 allrap[i]->therule->endident +1].vgrndp && 
	     edptr != NULL;
	   edptr = edptr->endnode->succs[0] )
	{
	  edptr->endnode->log_wkt = allrap[i]->rapwk;
	  if( strpbrk(((Cvgrnode*)edptr->endnode)->symbol,"#") )
	    {
	      //next wordno in vtr
	      for( ; 
		   strpbrk(vtrrecndlist[nwn].vgrndp->symbol,"#") == NULL &&
		     nwn < vtrndanz;
		   nwn++);
	      for( ; 
		   strpbrk(vtrrecndlist[nwn].vgrndp->symbol,"#") &&
		     nwn < vtrndanz;
		   nwn++);

	    }
	  else
	    {
	      ((Cvgrnode*)edptr->endnode)->wordnum = 
		vtrrecndlist[nwn].vgrndp->wordnum;
	    }
	}
      if( i == allrapanz-1 || csplakt != allrap[i + 1]->csplit )
	{
	  int csplitziel = (i == allrapanz-1) ? 
	    vtrndanz -1 : allrap[i + 1]->csplit;
	  //score the canedge
	  sumwk=0.0;
	  for( edptrptr=csptr->succs.skipThru(init);
	       edptrptr != NULL;
	       edptrptr=csptr->succs.skipThru(next) )
	    {
	      vgredge = (Cvgredge*)*edptrptr;
	      if( vgredge->endnode == vtrrecndlist[csplakt+1].vgrndp )
		{
		  continue;
		}
	      sumwk += exp( vgredge->log_uewkt );
	    }

	  if( sumwk > 1.0 )
	    {
	      failure(__FILE__,__LINE__,"internal error sumwk=%lf\n",sumwk);
	    }
	      
	  vgredge = 
	    (Cvgredge*)vargraph->isIn(csptr,
				      vtrrecndlist[csplakt+1].vgrndp );
	  vgredge->log_uewkt = log( 1 - sumwk );
	  
	  //propagate wk		      
	  for(  ; csplakt < csplitziel ; )
	    {
	      csptr = vtrrecndlist[++csplakt].vgrndp;
	      sumwk=0.0;
	      for( edptrptr=csptr->predecs.skipThru(init);
		   edptrptr != NULL;
		   edptrptr=csptr->predecs.skipThru(next) )
		{
		  vgredge = (Cvgredge*)*edptrptr;
		  sumwk += exp( vgredge->log_uewkt +
				vgredge->startnode->log_wkt );
		}
	      csptr->log_wkt = log( sumwk );
	    }

	}
      delete allrap[i];
    }
}
  
int cmpcsplit(const void* p1,const void* p2)
{
  int d;
  if( ( d= (*(ruleappl**)p1)->csplit - (*(ruleappl**)p2)->csplit ) != 0 )
    {
      return d;
    }
  else
    {
      return (*(ruleappl**)p1)->crecom - (*(ruleappl**)p2)->crecom;
    }
}
