//****************************************************************************
//
// CCfile: findwn_main.cc
//
// Autor: A. Kipp
// erstellt: Wed Nov 29 09:31:14 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "CCexceptions.h"
#include "Cdocsys.h"
#include "iotoolbox.h"
#include "Cfindwn.h"
#include "verbmobil.h"

static char inventar[] = "/home/kip/projekte/vorschlagstrans/inventar.txt";
char segoutfile[] = "seg.out";
char *ignoresymbols[] = {"<p:>","<nib>",NULL};

main(int argc,char** argv)
{
  char* appname,*hypin=NULL,*segin=NULL,*ch,*cp,*inventfile = inventar,
    dummy,hspkr[50],sspkr[50],line[200];
  char* segout = segoutfile;
  int hnum,snum;
  long pos;
  FILE* fp,*fphin,*fpsin=stdin,*fpsout;
  Chgraph *hgraph;
  Csegment_io* segio;
  Cfindwn* findwn;
  Cdocsys doc;
  int anzseg;
  vmfinfo vihgr,viseg;
  int verbose=1;
  
  segment_rec** sptrptr;
   
  icsiargtab_t args[] =
  {
    {"hif","Hypthesen-Inputfile",ARG_STR,&hypin,ARG_REQ},
    {"sif","Segmentations-INputfile",ARG_STR,&segin},
    {"iv","inventar-file",ARG_STR,&inventfile},
    {"v","verbose",ARG_BOOL,&verbose},
    {"sof","segmentation-out",ARG_STR,&segout},
    {0,0,(icsiarg_e)0}
  }; 
   
  try
    {
      // Start of code
      icsiargs(args,&argc,(const char ***)&argv,&appname);
      hgraph = new Chgraph;
      segio = new Csegment_io;
      findwn = new Cfindwn;
      findwn->verbose = verbose;
         
      if( hgraph->readInventar(inventfile) < 0 )
	{
	  failure(__FILE__,__LINE__,
		  "Error reading Inventar from %s",inventfile);
	}
    
      fphin = fopen(hypin,"r");
      if( fphin == NULL )
	{
	  failure(__FILE__,__LINE__,
		  "couldn't open %s\n",hypin);
	}
      hgraph->setIn(fphin);
    
      if( segin == NULL )
	{
	  segio->setIn(stdin);
	}
      else
	{
	  fpsin = fopen(segin,"r");
	  if( fpsin == NULL )
	    {
	      failure(__FILE__,__LINE__,
		      "couldn't open %s\n",segin);
	    }
	}
      segio->setIn(fpsin);
     

      
      fpsout = fopen(segout,"w");
      if( fpsout == NULL )
	{
	  failure(__FILE__,__LINE__,
		  "couldn't open %s\n",segout);
	}
      segio->setOut(fpsout);  
      doc.pipeInfo(fpsin,fpsout);
      doc.pipeInfo(fphin,fpsout);

      while( hgraph->readHGraph() == 0 )
	{
	  
	  segio->clear();
	  if( segio->readFile() < 0 ) 
	    {
	      failure(__FILE__,__LINE__,"Error in %s",segin);
	      break;
	    }

	  if( !vm1tkinfo(hgraph->filename,&vihgr) ||
	      !vm1tkinfo(segio->filename,&viseg) )
	    {
	      failure(__FILE__,__LINE__,"No vm-names: %s %s",
		      hgraph->filename,
		      segio->filename);
	    }

	  if( vihgr.modus != viseg.modus ||
	      vihgr.dlgnum != viseg.dlgnum ||
	      vihgr.ort != viseg.ort )
	    {
	      failure(__FILE__,__LINE__,"Trying to match different dialogs");
	    }
	  segment_rec** sptrptr;

	  while( vihgr.turnnum != viseg.turnnum )
	    {
	      if( vihgr.turnnum < viseg.turnnum )
		{
		  if( hgraph->readHGraph() != 0 )
		    {
		      break;
		    }
		  else
		    {
		      if( !vm1tkinfo(hgraph->filename,&vihgr) )
			{
			  failure(__FILE__,__LINE__,"No vm-names: %s %s",
				  hgraph->filename,
				  segio->filename);
			}
		    }
		}
	      else
		{
		  if( segio->readFile() < 0 )
		    {
		    break;
		    }
		  else
		    {
		      if( !vm1tkinfo(segio->filename,&viseg) )
			{
			  failure(__FILE__,__LINE__,"No vm-names: %s %s",
				  hgraph->filename,
				  segio->filename);
			}
		    }
		}
	    }

	  if( vihgr.turnnum != viseg.turnnum )
	    {
	      break;
	    }
	  if( verbose )
	    { 
	      printf("checking %s\n",hgraph->filename);
	    }	  
	  anzseg = segio->slist.compact(&sptrptr);
	  if( findwn->find(hgraph,sptrptr,anzseg) != anzseg )
	    {
	      fprintf(stdout,"Error getting wordnos for %s\n",
		      hgraph->filename);
	    }
	  else
	    {
	      segio->writeFile();
	    }
	  
	}
      // End of code 
    }
  catch(Ausnahme& a)
    {
      switch( a.code )
	{
	default:
	  fprintf(stderr,"%s %d : %s\n",a.file,a.line,a.message);
	  exit(1);
	}
    }
  catch(...)
    {
      exit(2);
    }
}
