//****************************************************************************
//
// CCfile: Cvektor.cc
//
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//
// Enthaelt:
//****************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Cvektor.h"



//***************************************************************************
// Implementierung der Klasse: Cvektor
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

Cvektor::Cvektor(double* x,int dim) 
  {
  data = x;
  dimension=dim; 
  mem=0;
  }

Cvektor::Cvektor(int dim) 
  { 
  data = new double[dim];
  dimension=dim; 
  if( data == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
  mem=1;
  } 

// copy construktor
Cvektor::Cvektor(Cvektor& vek) 
  { 
  data = new double[vek.dimension];
  dimension=vek.dimension; 
  if( data == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
  memcpy(data,vek.data,dimension*sizeof(double));
  mem=1;
  } 

void Cvektor::printVek()
  {
  int i;

  for( i=0 ; i<dimension ; i++ )
    {
    printf("x[%d]=%lf\n",i,getVal(i));
    }
  }

void Cvektor::clearVek()
  {
  memset(data,0,dimension*sizeof(double));
  }

double Cvektor::operator*(Cvektor& vek)
  {
  int i;
  double d=0.0;

  if( dimension != vek.dimension)
    {
    fprintf(stderr,"Dimensions of vektors must be equal\n");
    exit(1);
    }

  for(i=0 ; i<dimension ; i++ )
    {
    d+= getVal(i)*vek.getVal(i);
    }

  return d;
  }

Cvektor& Cvektor::operator=(Cvektor& vek)
  {

  if( dimension != vek.dimension )
    {
    fprintf(stderr,"Dimensions of vektors must be equal\n");
    exit(1);
    }
 
  memcpy(data,vek.data,dimension*sizeof(double));
  return *this;
  }
  
Cvektor::~Cvektor()
  {
  if( mem )
    {
    delete [] data;
    }
  }

