# inserts or expands the final silence interval by TRNFINAL
# samples, thus correcting the error caused by cutting out the
# utterance from the original recording using the option USETRN.
# If the final interval is not a silence interval ($4 != -1) then 
# maus was running with NOINITIALFINALSILENCE=true and the the final
# interval is a segment to be left untouched, and an extra silence 
# interval is added that covers the rest of the signal file (or chunk)
BEGIN { first = 0 }
    {
      if ( first == 0 )
        first = 1
      else 
        print oldline
      oldline = $0
    }
END {
      if ( $4 == -1 ) {
        printf("MAU:\t%d\t%d\t%d\t%s\n",$2,$3+TRNFINAL-2,$4,$5)
      }
      else {
        printf("MAU:\t%d\t%d\t%d\t%s\n",$2,$3,$4,$5)
        printf("MAU:\t%d\t%d\t-1\t<p:>\n",$2+$3+1,TRNFINAL-2)
      }
}
