//****************************************************************************
//
// CCfile: Cperplex.cc
//
// Autor: A. Kipp
// erstellt: Tue Apr 8 08:28:21 MET DST 1997
// veraendert:
//
// Enthaelt:
//***************************************************************************
#include "Cperplex.h"
#include "CCexceptions.h"
#include <math.h>
#include <limits.h>

struct velm
{
  velm() { idx=-1;score=(-1) * DBL_MAX;backni = backvi =-1;};
  int backni;
  int backvi;
  int idx;
  double score;
};

struct velmcont
{
  velm* v;
  int anz;
};


//***************************************************************************
// Implementierung der Klasse: Cperplex
// Autor: A. Kipp
// erstellt: Tue Apr 8 08:28:21 MET DST 1997 
// veraendert:
//***************************************************************************
double Cperplex::find(Chgraph* hgr,mlfsegment_rec** srl,int anzl)
{
  Cnode** ndlist;
  //hgr und segio muessen sich auf das gleiche file beziehen
  double perplex = DBL_MAX;
  double penal;
  int maxrank = hgr->getRanks();
  int ndanz= hgr->nodes.compact(&ndlist); 
  //in dieser Reihenfolge, nach Rang geordnet, kann gesucht werden
  qsort(ndlist,ndanz,sizeof(Cnode*),compranks);

  velmcont *vels = new velmcont[ndanz];

  int i,j;
  for( i=0 ; i<ndanz ; i++ )
    {
      ndlist[i]->nodenr = i;
      vels[i].v = new velm[anzl];
      vels[i].anz = anzl;
    }

  for( i=0 ; i<ndanz && ndlist[i]->rank == 0 ; i++ )
    {
      if( !strcmp( ((Chgrnode*)ndlist[i])->symbol, srl[0]->symbol ) ) 
	{
	  vels[i].v[0].idx = 0;
	  vels[i].v[0].score =0.0;
	}
    }

  Cedge** edptrptr;
  int targetnode;
  int thinx;

  for( i=0 ; i < ndanz ; i++ )
    {
      for( j=0 ; j<vels[i].anz ; j++ )
	{
	  if( vels[i].v[j].idx < 0 || vels[i].v[j].idx > anzl - 2)
	    {
	      continue;
	    }
	  for( edptrptr=((Chgrnode*)ndlist[i])->succs.skipThru(init) ; 
	       edptrptr != NULL ; 
	       edptrptr=((Chgrnode*)ndlist[i])->succs.skipThru(next) )
	    {
	      targetnode = (*edptrptr)->endnode->nodenr;
	      thinx = vels[i].v[j].idx;
	      if( !isNull( ((Chgrnode*)ndlist[targetnode ])->symbol) )
		{
		  penal = isequ(srl[thinx + 1 ]->symbol,
			 ((Chgrnode*)ndlist[targetnode])->symbol);
		  if( penal > 0.0 )
		    {
		      continue;
		    }
		  if( vels[i].v[j].score + (*edptrptr)->log_uewkt + penal>
		      vels[targetnode].v[thinx + 1  ].score )
		    {
		      //change it
		      vels[targetnode].v[thinx + 1].score =
			vels[i].v[j].score + (*edptrptr)->log_uewkt + penal;
		      vels[targetnode].v[thinx + 1].idx = 
			thinx + 1;
		      vels[targetnode].v[thinx + 1].backni = i;
		      vels[targetnode].v[thinx + 1].backvi = j;
		    }
		}
	      else
		{
		  if( vels[i].v[j].score + (*edptrptr)->log_uewkt >
		      vels[targetnode].v[ thinx ].score )
		    {
		      //change it
		      vels[targetnode].v[ thinx ].score =
			vels[i].v[j].score + (*edptrptr)->log_uewkt;
		      vels[targetnode].v[ thinx ].idx = thinx;
		      vels[targetnode].v[ thinx ].backni = i;
		      vels[targetnode].v[ thinx ].backvi = j;
		    }
		}
	    }
	}

      if( !strcmp(">",((Chgrnode*)ndlist[i])->symbol ) )
	{
	  if( vels[i].v[ anzl-1 ].idx > 0 )
	    {
	      //bingo
	      perplex = vels[i].v[ anzl-1].score;
	      if( verbose )
		{
		  printf("success\n");
		  int bn=i;
		  int bv=anzl-1;
		  int tn;
		  while( bn>=0 && bv >= 0 )
		    {
		      printf("%s%s\n",
			     strcmp("!NULL",
				    ((Chgrnode*)ndlist[bn])->symbol) ?
			     srl[vels[bn].v[bv].idx]->symbol : "!NULL",
			     !strcmp("**",
				     ((Chgrnode*)ndlist[bn])->symbol) ?
			     "(*)" : "");
		      tn = bn;
		      bn = vels[bn].v[bv].backni;
		      bv = vels[tn].v[bv].backvi;
		    }
		}
	    }
	  else
	    {
	      if(verbose)
		{
		  printf("no sucess\n");
		  int k,kk;
		  for( k=0 ; k<ndanz ; k++ )
		    {
		      printf("node %d (%s)\n",
			     k,((Chgrnode*)ndlist[k])->symbol);
		      for( kk=0 ; kk<vels[k].anz ; kk++ )
			{
			  if( vels[k].v[kk].idx < 0 )
			    {
			      continue;
			    }
			  printf("idx %d\n",vels[k].v[kk].idx);
			}
		    }
		}
	    }
	}
    }

  for( i=0 ; i<ndanz ; i++ )
    {
      if( vels[i].anz == 1 )
	{
	  delete vels[i].v;
	}
      else
	{
	  delete [] vels[i].v;
	}
    }
  delete [] vels;
	      
  delete [] ndlist;
  return (-1) * perplex / log(2);

}

double Cperplex::isequ(char* s1,char* s2)
{
  char** cpp;

  if( !strcmp(s1,s2) )
    {
      return 0.0;
    }
  else
    {
      for( cpp=jokers.skipThru(init) ; cpp != NULL ; 
	   cpp=jokers.skipThru(next) )
	{
	  if( !strcmp( *cpp,s2 ) )
	    {
	      return log( 1.0/(anzkl-1) );
	    }
	}
    }
  return 10.0;
}

int Cperplex::isNull(char* s)
{
  char **cpp;

  for( cpp=nulls.skipThru(init) ; cpp != NULL ; 
       cpp=nulls.skipThru(next) )
    {
      if( !strcmp( *cpp,s ) )
	{
	  return 1;
	}
    }
  return 0;
}
	    

	      
      
