//****************************************************************************
//
// CCfile: Cgraphvis.cc
//
// Autor: A. Kipp
// erstellt: Wed Apr 17 10:46:20 1996 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include <stdlib.h>
#include <math.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrolledW.h>

#include "Cgraphvis.h"
#include "CCexceptions.h"

#define GRTEMPLATE "graphvis"
#define EPSPRE "epspre"
#define EPSTRAIL "epstrail"
#define R_KN 0.25
#define R_ND 0.15

int compgrranks(const void* p1,const void* p2);
void displayExCB(Widget w,XtPointer cd,XtPointer ad);


//***************************************************************************
// Implementierung der Klasse: Cgraphvis
// Autor: A. Kipp
// erstellt: Wed Apr 17 10:46:20 1996 
// veraendert:
//***************************************************************************
Cgraphvis::Cgraphvis(int nd,int ka)
{
  nodedist = nd;

  kananz = ka;
  pages=1;
  psout = new Cpsout("graphvis");
}

int Cgraphvis::initDrawing(char** argv,int* argcp)
{

  toplevel = XtAppInitialize(&app,argv[0],NULL,0,argcp,argv,NULL,NULL,0);

  mainwin = XtVaCreateManagedWidget("mainwin",xmScrolledWindowWidgetClass,
  				    toplevel,
				    XmNscrollingPolicy,XmAUTOMATIC,NULL);
  drawar = XtVaCreateManagedWidget("drawar",xmDrawingAreaWidgetClass,
				   mainwin,NULL);
  XtAddCallback(drawar ,XmNexposeCallback, displayExCB, (XtPointer*)this);

  //XmMainWindowSetAreas(mainwin,NULL,NULL,NULL,NULL,drawar);

  Window root = RootWindowOfScreen(XtScreen(drawar));
  maske = 0;
  //GCs fuer die Datendarstellung
  bg = WhitePixelOfScreen(XtScreen(drawar));
  fg = BlackPixelOfScreen(XtScreen(drawar));
  
  werte.foreground = fg;
  werte.background = bg;
  maske = GCForeground | GCBackground ;
  gc = XCreateGC(XtDisplay(drawar),root,maske,&werte);

  //Font
  if( ( fontinfo = XLoadQueryFont(XtDisplay(drawar),"9x15")) == NULL )
    {
      failure(__FILE__,__LINE__,"Error loading font");
    }

  XSetFont(XtDisplay(drawar),gc,fontinfo->fid);

}

void Cgraphvis::run()
{
  XtRealizeWidget(toplevel);
  XtAppMainLoop(app);
}
void Cgraphvis::setGC(Pixel fog,Pixel bag,int function)
  {
  werte.foreground = fog;
  werte.background = bag;
  werte.function = function;
  maske=0;
  maske = GCForeground | GCBackground | GCFunction;
  XChangeGC(XtDisplay(drawar),gc,maske,&werte);
  
  }

void Cgraphvis::draw(XmDrawingAreaCallbackStruct* dainfo)
{
  int i;
  int rnx,rny;
  Cgraphvisnode* gnp;
  Cedge** edptrptr;
  Cgraphvisedge *gedp;
  char* cp;
  char nlstr[] = "(0)";
  char nr[10];
  int fontheight = fontinfo->ascent + fontinfo->descent;
  int textwidth;
  XRectangle cliprec;

  cliprec.x = dainfo->event->xexpose.x;
  cliprec.y = dainfo->event->xexpose.y;
  cliprec.width = dainfo->event->xexpose.width;
  cliprec.height = dainfo->event->xexpose.height;

  XSetClipRectangles(XtDisplay(drawar),gc,0,0,
		     &cliprec,1,Unsorted);
  
  setGC(bg,fg,GXcopy);
  XFillRectangle(XtDisplay(drawar),XtWindow(drawar),gc,0,0,
		 (unsigned)width,(unsigned)height);
  setGC(fg,bg,GXcopy);
  for( edptrptr = edges.skipThru(init);
       edptrptr != NULL;
       edptrptr = edges.skipThru(next) )
    {
      gedp = (Cgraphvisedge*)(*edptrptr);
      if( gedp->npts > 0 )
	{
	  XDrawLines(XtDisplay(drawar),XtWindow(drawar),
		     gc,gedp->pts,gedp->npts,CoordModeOrigin);
	}
      if( gedp->npts == 2 )
	{
	  rnx = 2*gedp->pts[0].x/3 + gedp->pts[1].x/3;
	  rny = 2*gedp->pts[0].y/3 + gedp->pts[1].y/3 - (gedp->pts[0].y <
          gedp->pts[1].y ? fontheight : 0);
	}
      else if( gedp->npts == 4 )
	{
	  rnx = (gedp->pts[1].x + gedp->pts[2].x )/2;
	  rny = gedp->pts[1].y;
	}

      sprintf(nr,"%lf",exp(gedp->log_uewkt));
      textwidth = XTextWidth(fontinfo,nr,strlen(nr));
      XDrawString(XtDisplay(drawar),XtWindow(drawar),
		  gc,rnx - textwidth/2,rny,
		  nr,strlen(nr));
    }

  setGC(bg,fg,GXcopy);

  for( i=0 ; i<ndanz ; i++ )
    {
      gnp = (Cgraphvisnode*)ndlist[i];
      XFillArc(XtDisplay(drawar),XtWindow(drawar),
	       gc,gnp->loc.x - (short)(nodedist*R_ND),
	       gnp->loc.y - (short)(nodedist*R_ND),(short)(nodedist*2*R_ND),
	       (short)(nodedist*2*R_ND),0,360 * 64);
    }
  setGC(fg,bg,GXcopy);

  for( i=0 ; i<ndanz ; i++ )
    {
      gnp = (Cgraphvisnode*)ndlist[i];
      XDrawArc(XtDisplay(drawar),XtWindow(drawar),
	       gc,gnp->loc.x - (short)(nodedist*R_ND),
	       gnp->loc.y - (short)(nodedist*R_ND),(short)(nodedist*2*R_ND),
	       (short)(nodedist*2*R_ND),0,360 * 64);
      if( gnp->symbol == NULL )
	{
	  cp = nlstr;
	}
      else
	{
	  cp = gnp->symbol;
	}

      textwidth = XTextWidth(fontinfo,cp,strlen(cp));
      XDrawString(XtDisplay(drawar),XtWindow(drawar),
		  gc,gnp->loc.x - textwidth/2,gnp->loc.y+fontheight,
		  cp,strlen(cp));
      sprintf(nr,"%d",gnp->nodenr);
      textwidth = XTextWidth(fontinfo,nr,strlen(nr));
      XDrawString(XtDisplay(drawar),XtWindow(drawar),
		  gc,gnp->loc.x,gnp->loc.y,
		  nr,strlen(nr));

    }
}

int Cgraphvis::psOut(char* filename)
{

  FILE* fp,*fpin;
  int i,page;
  Cgraphvisnode* gnp;
  Cedge** edptrptr;
  Cgraphvisedge *gedp;
  char line[100];

  if( eps )
    {
      //BoundingBox
      fprintf(*psout,"%%%%DocumentFonts: Courier\n");
      fprintf(*psout,"%%%%BoundingBox: 0 0 %d %d\n",width,height);
      psout->need(EPSPRE);
    }

  psout->need(GRTEMPLATE);
  
  psout->need("arrowdict");

  fprintf(*psout,"graphvisDict begin\n");
  fprintf(*psout,"arrowdict begin\n");
  fprintf(*psout,"/nodewidth %d def /Courier findfont nodewidth 0.8 mul scalefont setfont\n",
	      (int)(nodedist * R_ND));
  fprintf(*psout,"nodewidth 20 div ceiling setlinewidth\n");
  fprintf(*psout,"/DoPage {\n");
  //Kanten
  fprintf(*psout,"newpath\n");
  for( edptrptr = edges.skipThru(init);
       edptrptr != NULL;
       edptrptr = edges.skipThru(next) )
    {
      gedp = (Cgraphvisedge*)(*edptrptr);
      if( gedp->log_uewkt < 0 )
	{
	  double wk = exp(gedp->log_uewkt);
          //printf("log(%f) = %f\n",wk,gedp->log_uewkt);
	  fprintf(*psout,"%d %d %d %d (%f) beschrifteLinie\n",
		  gedp->pts[0].x, gedp->pts[0].y,
		  gedp->pts[1].x, gedp->pts[1].y,
		  wk);
	}
      fprintf(*psout,"%d %d moveto\n",gedp->pts[0].x, gedp->pts[0].y);

      for( i=1 ; i< gedp->npts - 1 ; i++ )
	{
	  fprintf(*psout,"%d %d %d %d %lf arcto moveto pop pop\n",
		  gedp->pts[i].x,
		  gedp->pts[i].y,
		  gedp->pts[i+1].x,
		  gedp->pts[i+1].y,
		  (nodedist * R_ND)
		  );
	}
      int dx = gedp->pts[gedp->npts - 2].x -
	gedp->pts[gedp->npts - 1].x;
      int dy = gedp->pts[gedp->npts - 2].y -
	gedp->pts[gedp->npts - 1].y;
      double arc = atan( dy/dx );
      fprintf(*psout,"currentpoint %lf %lf doArrow\n",
	      (double)gedp->pts[gedp->npts - 1].x - (nodedist * R_ND)
	      * cos(arc),
	      (double)gedp->pts[gedp->npts - 1].y - (nodedist * R_ND)
	      * sin(arc));
      
      /*
      if( gedp->npts == 2 )
	{
	  fprintf(*psout,"%lf %lf moveto (%1.4lf) show\n",
		  2*(double)gedp->pts[0].x/3 + (double)gedp->pts[1].x/3,
		  2*(double)gedp->pts[0].y/3 + (double)gedp->pts[1].y/3,
		  exp(gedp->log_uewkt));
	}
      else if( gedp->npts == 4 )
	{
	  fprintf(*psout,"%lf %lf moveto (%1.4lf) show\n",
		  (double)(gedp->pts[1].x + gedp->pts[2].x )/2,
		  (double)gedp->pts[1].y,exp(gedp->log_uewkt));
	}
	*/
    }
  fprintf(*psout,"stroke\n");
      
  for( i=0 ; i<ndanz ; i++ )
    {
      gnp = (Cgraphvisnode*)ndlist[i];
      if( gnp->symbol == NULL || !strcmp(gnp->symbol,"!NULL") )
	{
	  fprintf(*psout,"%d %d DoNullNode\n",gnp->loc.x, gnp->loc.y);
	}
      else
	{
	  fprintf(*psout,"%d %d (%s) DoNode\n",gnp->loc.x, gnp->loc.y, 
	      gnp->symbol);
	}
    }
  fprintf(*psout,"stroke showpage\n");
  fprintf(*psout,"} def\n");

  if( eps )
    {
      fprintf(*psout,"DoPage\n");
      psout->need(EPSTRAIL);
      psout->writeFile(filename,1);
    }
  else
    {
      //in seiten brechen
      for( page=0 ;  page < pages ; page++)
	{
	  fprintf(*psout,"%%%%Page: %d %d\n",page,page);
	  fprintf(*psout,"90 rotate\n");
	  fprintf(*psout,"%d -500 translate\n",14 + (-1)*page*810);
	  fprintf(*psout,"%lf %lf scale\n",
		  pages*810.0/width,pages*810.0/width);
	  fprintf(*psout,"DoPage\n");
	}
      psout->writeFile(filename,page);
    }
  return 0;
}

int Cgraphvis::calculate()
{
  int i,r,rmax,rank,k;
  Cgraphvisnode* gnp,*sgnp;
  Cedge** edptrptr;
  Cgraphvisedge *gedp;
  kanal *knp,**knptrptr;
  int addkans = 0;
  int dist;

  if( getRanks() < 0 )
    {
      return -1;
    }

  ndanz = nodes.compact(&ndlist);
  qsort((char*)ndlist,ndanz,sizeof(Cnode*),compgrranks);

  for( rank=0, i=0, rmax=0,r=0; i<ndanz ; i++,r++ )
    {
      if( ndlist[i]->rank > rank )
	{
	  if( r > rmax )
	    {
	      rmax = r;
	    }
	  r=0;
	  rank = ndlist[i]->rank;
	}

     gnp = (Cgraphvisnode*)ndlist[i];

     gnp->loc.x = (rank + 1) * nodedist;
     gnp->loc.y = (r + 1) * nodedist;
    }

  for( i=0 ; i<rmax ; i++ )
    {
      for( r=0 ; r<kananz ; r++ )
	{
	  knp = new kanal(maxrank + 1);
	  knp->ky = (short)(nodedist * (i + R_KN + (1-2*R_KN)*r/(kananz-1)));
	  kanaele.addEl(&knp);
	}
    }

  for( i=0; i<ndanz ; i++ )
    {
      gnp = (Cgraphvisnode*)ndlist[i];
      
      for( edptrptr=gnp->succs.skipThru(init) ;
	   edptrptr != NULL;
	   edptrptr=gnp->succs.skipThru(next) )
	{
	  gedp = (Cgraphvisedge*)(*edptrptr);
	  sgnp = (Cgraphvisnode*)gedp->endnode;
	  if( sgnp->rank == gnp->rank + 1 )
	    {
	      //einfach mit dem naechsten verbinden
	      gedp->pts = new XPoint[2];
	      gedp->pts[0] = gnp->loc;
	      gedp->pts[1] = sgnp->loc;
	      gedp->npts = 2;
	    }
	  else
	    {
	      //freien kanal suchen
	      dist = 5*rmax*nodedist;
	      for( knptrptr=kanaele.skipThru(init),knp=NULL;
		   knptrptr != NULL ;
		   knptrptr=kanaele.skipThru(next) )
		{
		  for( r=gnp->rank +1  ; r<sgnp->rank ; r++ )
		    {
		      if( (*knptrptr)->occupied[r] )
			{
			  break;
			}
		    }
		  if( r == sgnp->rank && 
		      abs(gnp->loc.y - (*knptrptr)->ky) +
		      abs(sgnp->loc.y - (*knptrptr)->ky) < dist)
		    {
		      //freier kanal, belegen
		      dist = abs(gnp->loc.y - (*knptrptr)->ky)+
		      abs(sgnp->loc.y - (*knptrptr)->ky);
		      knp = *knptrptr;
		    }
		}

	      if( knp == NULL )
		{
		  knp = new kanal(maxrank + 1);
		  knp->ky = (short)(nodedist* 
				    (rmax + R_KN + 
				     (1-2*R_KN)*(addkans++)/(kananz-1)));
		  kanaele.addEl(&knp);
		}

	      for( r=gnp->rank +1  ; r<sgnp->rank ; r++ )
		{
		  knp->occupied[r]=1;
		}

	      gedp->pts = new XPoint[4];
	      gedp->pts[0] = gnp->loc;
	      gedp->pts[3] = sgnp->loc;
	      gedp->pts[1].x = gnp->loc.x + (short)(nodedist*(1-R_ND));
	      gedp->pts[1].y = knp->ky;
	      gedp->pts[2].x = sgnp->loc.x - (short)(nodedist*(1-R_ND));
	      gedp->pts[2].y = knp->ky;
	      gedp->npts = 4;
	    }
	}
	      

    }
  width =nodedist * (maxrank + 2);
  height=nodedist*(rmax+2);

  XtVaSetValues(toplevel,XmNheight,height + 30,
		XmNwidth,900,NULL );
  XtVaSetValues(mainwin,XmNheight,height + 20,
		XmNwidth,875,NULL );
  XtVaSetValues(drawar,XmNheight,height,
		XmNwidth,width,NULL );
}


Cnode* Cgraphvis::newNode() 
  {
  return new Cgraphvisnode;
  }

Cedge* Cgraphvis::newEdge()
  {
  return new Cgraphvisedge;
  }

int compgrranks(const void* p1,const void* p2)
{
  Cgraphvisnode* gnp1,*gnp2;

  gnp1 = (Cgraphvisnode*)(*(Cnode**)p1);
  gnp2 = (Cgraphvisnode*)(*(Cnode**)p2);

  if( gnp1->rank != gnp2->rank )
    {
      return gnp1->rank - gnp2->rank;
    }
  else
    {
      return gnp1->nodenr - gnp2->nodenr;
    }

}

Cgraphvis::~Cgraphvis()
{
  delete [] ndlist;
  delete psout;
}


void displayExCB(Widget w,XtPointer cd,XtPointer ad)
  {
  ((Cgraphvis*)cd)->draw((XmDrawingAreaCallbackStruct*)ad);
  }
