//***************************************************************************
//
// Headerfile: iotoolbox.h
//
// Autor: A.Kipp
// erstellt: veraendert:
//
// Enthaelt: routinen zum einlesen und ausgeben von datenfiles
//***************************************************************************
#ifndef IOTOOLBOX
#define IOTOOLBOX

#include "Cverklist.h"

#define MAXLABLEN 15

struct labrec
  {
  labrec() { start=0; lab[0]='\0'; score=0.0;};
  long start;
  char lab[MAXLABLEN];
  double score;
  };
  
struct phondatlabelinf
  {
  char* filename;
  char* kano;
  char* ortho;
  char* h;
  
  Cverklist<labrec*> lablist;
  };

long read_phondat_speechfile(char* name, short** sbufptr);
FILE* open_phondat_speechfile(char* name);
int read_phondat_label_file(char* name,struct phondatlabelinf* plinf);
void swap_short(short* s,int anz);
int write_phondat_label_file(char* name,struct phondatlabelinf* plinf);

#endif
