//****************************************************************************
//
// CCfile: CfileIO.cc
//
// Autor: A. Kipp
// erstellt: Fri Sep 6 16:37:28 MET DST 1996
// veraendert:
//
// Enthaelt:
//***************************************************************************
#include "CfileIO.h"
#include "CCexceptions.h"

//***************************************************************************
// Implementierung der Klasse: CfileIO
// Autor: A. Kipp
// erstellt: Fri Sep 6 16:37:28 MET DST 1996 
// veraendert:
//***************************************************************************
CfileIO::CfileIO()
{
  fpin = fpout = NULL;
  setLinelen(FILEIO_LINELEN);
}

int CfileIO::openRead(char* filename)
{
  if( fpin != NULL )
    {
      closeRead();
    }

  if( (fpin=fopen(filename,"r")) == NULL )
    {
      return -1;
    }
  else
    {
      return 1;
    }
}

int CfileIO::openWrite(char* filename)
{
  if( fpout != NULL )
    {
      closeRead();
    }

  if( (fpout=fopen(filename,"w")) == NULL )
    {
      return -1;
    }
  else
    {
      return 1;
    }
}

void CfileIO::closeRead()
{
  fclose(fpin);
}

void CfileIO::closeWrite()
{
  fclose(fpout);
}

int CfileIO::getNextLine(char* line)
{
  if( fgets(line,linelen,fpin) )
    {
      return 1;
    }
  else
    {
      return 0;
    }
}

int CfileIO::putLine(char* line)
{
  return fputs(line,fpout);
}

long CfileIO::readData(void* data,long bytes)
{
  return fread(data,1,bytes,fpin);
}

long CfileIO::getDataLength()
{
}

long  CfileIO::writeData(void* data,long bytes)
{
  return fwrite(data,1,bytes,fpout);
}
