//****************************************************************************
//
// CCfile: Cmatrix.cc
//
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//
// Enthaelt:
//****************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Csym_matrix.h"


//***************************************************************************
// Implementierung der Klasse: Csym_matrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

Csym_matrix::Csym_matrix(int dim) : Cquad_matrix()
  {
  int i;
  double *dp;

  num_of_actel = dim*(dim+1)/2;
  data = new double[ num_of_actel ];
  pp_row = new Cvektor*[dim];
  if( pp_row == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  num_of_cols=dim;
  num_of_rows=dim;

  for( i=0,dp=data ; i<dim ; i++ )
    {
    pp_row[i]=new Cvektor(dp,dim-i);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    dp += dim-i;
    }
  mem=1;
  }

Csym_matrix::Csym_matrix(double* x,int dim) : Cquad_matrix()
  {
  int i;
  double *dp;

  num_of_actel = dim*(dim+1)/2;
  data = x;
  pp_row = new Cvektor*[dim];
  if( pp_row == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  num_of_cols=dim;
  num_of_rows=dim;

  for( i=0,dp=data ; i<dim ; i++ )
    {
    pp_row[i]=new Cvektor(dp,dim-i);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    dp += dim-i;
    }
  mem=0;
  }  

Cquad_matrix Csym_matrix::sym2Quad()
  {
  int i,j;
  Cquad_matrix erg(num_of_rows);

  for( i=0 ; i<num_of_rows ; i++)
    {
    for( j=0 ; j<num_of_rows ; j++)
      {
      erg.setVal(i,j,getVal(i,j));
      }
    }
  return erg;
  }
  

double Csym_matrix::getVal(int r, int c)
  {
  if( c >= r )
    {
    return pp_row[r]->getVal(c-r);
    }
  else
    {
    return pp_row[c]->getVal(r-c);
    }
  }   

void Csym_matrix::setVal(int r, int c, double l)
  {
  if( c >= r )
    {
    pp_row[r]->setVal(c-r,l);
    }
  else
    {
    pp_row[c]->setVal(r-c,l);
    }
  }
 
void Csym_matrix::incVal(int r, int c, double l)
  {
  if( c >= r )
    {
    pp_row[r]->incVal(c-r,l);
    }
  else
    {
    pp_row[c]->incVal(r-c,l);
    }
  }

void Csym_matrix::decVal(int r, int c, double l)
  {
  if( c >= r )
    {
    pp_row[r]->decVal(c-r,l);
    }
  else
    {
    pp_row[c]->decVal(r-c,l);
    }
  }
  
void Csym_matrix::clearMat()
  {
  memset(data,0,num_of_actel*sizeof(double));
  }


/*
Cquad_matrix::Cquad_matrix(Csym_matrix* smat) : 
  Cmatrix(smat->num_of_rows,smat->num_of_rows)
  {
  int i,j;
  // Zuweisung der Daten
  for( i=0 ; i<num_of_rows ; i++ )
    {
    for( j=0 ; i<num_of_rows ; i++ )
      {
      setVal(i,j,smat->getVal(i,j));
      }
    }
  }
*/
