//***************************************************************************
//
// Headerfile: Cvektor.h
//
// Autor: A.Kipp
// erstellt: veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CVEKTOR
#define CVEKTOR


// Vorankuendigung
class Cmatrix;
class Cquad_matrix;

//***************************************************************************
// Klassendeklaration: Cvektor
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
// Kurzbeschreibung: selbsterklaerend
//***************************************************************************

class Cvektor
  {
  friend class Cmatrix;
  friend class Cquad_matrix;
  public:
  Cvektor(double* x,int dim);
  Cvektor(int dim);
  // copy constructor
  Cvektor(Cvektor& vek);
  double getVal( int n) {return data[n];};
  void setVal( int n, double l) { data[n]=l;};
  void incVal( int n, double l) { data[n] += l;};
  void decVal( int n, double l) { data[n] -= l;};
  void copyVek(Cvektor* ziel);
  void clearVek();
  int dim() { return dimension;};
  void printVek();
  
  double* getDataPtr() { return data;};
  // operatoren
  double operator*(Cvektor& vek);
  Cvektor& operator=(Cvektor& vek);
  
  ~Cvektor();

  private:
  double* data;
  int dimension;
  short mem;
  };

#endif

