//****************************************************************************
//
// CCfile: Ccomplex.cc
//
// Autor: A. Kipp
// erstellt: Mon Apr  1 12:44:59 1996 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "Ccomplex.h"
#include "CCexceptions.h"
#include <math.h>

//***************************************************************************
// Implementierung der Klasse: Ccomplex
// Autor: A. Kipp
// erstellt: Mon Apr  1 12:44:59 1996 
// veraendert:
//***************************************************************************
Ccomplex::Ccomplex()
{
  ima = 0.0;
  rea = 0.0;
}

Ccomplex::Ccomplex(double d)
{
  ima = 0.0;
  rea=d;
}

Ccomplex::Ccomplex(const char* string)
{
 *this = string;
}

double Ccomplex::im(Ccomplex z)
{
  return ima;
}

double Ccomplex::re(Ccomplex z)
{
  return rea;
}


Ccomplex& Ccomplex::operator=(const Ccomplex& z)
{
  rea = z.rea;
  ima = z.ima;
  return *this;
}

Ccomplex& Ccomplex::operator=(const char* string)
{
  double a,p;
  if( sscanf(string,"%lf+j%lf",&rea,&ima) == 2 )
    {
      return *this;
    }
  else if( sscanf(string,"%lf-j%lf",&rea,&ima) == 2 )
    {
      ima *= (-1);
      return *this;
    }
  else if( sscanf(string,"%lfej%lf",&a,&p) == 2 )
    {
      return *this;
    }
  else
    {
      printf("cannot convert %s to complex\n",string);
    }
}

Ccomplex Ccomplex::operator+(Ccomplex& z)
{
  Ccomplex res = *this;
  res += z;
  return res;
}

Ccomplex Ccomplex::operator-(Ccomplex& z)
{
  Ccomplex res = *this;
  res -= z;
  return res;
}

Ccomplex Ccomplex::operator*(Ccomplex& z)
{
  Ccomplex res = *this;
  res *= z;
  return res;
}

Ccomplex Ccomplex::operator/(Ccomplex& z)
{
  Ccomplex res = *this;
  res /= z;
  return res;
}

Ccomplex& Ccomplex::operator+=(Ccomplex& z)
{
  rea+=z.rea;
  ima+=z.ima;
  return *this;
}

Ccomplex& Ccomplex::operator-=(Ccomplex& z)
{
  rea-=z.rea;
  ima-=z.ima;
  return *this;
}

Ccomplex& Ccomplex::operator*=(Ccomplex& z)
{
  double a = zabs(z) * zabs(*this);
  double b = zarg(z) + zarg(*this);

  ima = a*sin(b);
  rea = a*cos(b);
}

Ccomplex& Ccomplex::operator/=(Ccomplex& z)
{
  double a = zabs(*this) / zabs(z);
  double b = zarg(*this) - zarg(z);

  ima = a*sin(b);
  rea = a*cos(b);
}

ostream& operator<<(ostream& os,Ccomplex& z)
{
  printf("%lf+j%lf",z.rea,z.ima);
  return os;
}

double zabs(Ccomplex z)
{
  return sqrt( z.ima*z.ima + z.rea*z.rea );
};

double zarg(Ccomplex z)
{
  return atan2(z.ima,z.rea);
}
