//***************************************************************************
//
// Headerfile: Cgraph.h
//
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CGRAPH
#define CGRAPH

#include <stdio.h>
#include <stdlib.h>
#include "Cverklist.h"

#define NOVALID_EDGE -1
#define NOVALID_NODE -1
#define NOMORE -1

#define NODELISTSTART "##nodelist\n"
#define NODELISTEND "##end\n"
#define EDGELISTSTART "##edgelist\n"
#define EDGELISTEND "##end\n"

#define SIZEMASK "N=%d L=%d\n"
#define NODEMASK "I=%d"
#define EDGEMASK "J=%d"

class Cnode;
class Cedge;

class Cnode
  {
  public:
  Cnode() { nodenr=-1; rank=-1;addinfo=NULL;log_wkt=0.0;};
  virtual ~Cnode() { };

  int nodenr;
  int rank;
  double log_wkt;

  char* addinfo;
  
  Cverklist<Cedge*> predecs;
  Cverklist<Cedge*> succs;
  };
  
class Cedge
  {
  public:
  Cedge() {startnode=NULL;endnode=NULL;addinfo=NULL;log_uewkt=0.0;};
  virtual ~Cedge() {};

  Cnode* startnode;
  Cnode* endnode;
  
  double log_uewkt;
  char*addinfo;
  };

int compranks(const void* p1,const void* p2);

//***************************************************************************
// Klassendeklaration: class Cgraph
//
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
class Cgraph
  {
  public:
  Cgraph();
  
  
  virtual Cnode* addNode(Cnode* nd = NULL);
  virtual Cedge* addEdge(Cedge* ed,Cnode* begn = NULL,Cnode* endn=NULL);
  Cedge* isIn(Cnode* begn,Cnode* endn);
  virtual Cnode* newNode();
  virtual Cedge* newEdge();
  virtual int setNode(Cnode* ndptr,char* key,char* value);
  virtual char* putNodeInfo(Cnode* ndptr,char* target);
  virtual int setEdge(Cedge* edptr,char* key,char* value);
  virtual char* putEdgeInfo(Cedge* edptr,char* target);
  
  virtual void setSize(char* key,char* value);

  int readGraph(FILE* fp = stdin);
  void writeGraph(FILE* fp = stdout);
  void delNode(int nodenr);
  void delNode(Cnode* ndptr,Cnode*** succlist=NULL,int* nsucs=NULL,
                            Cnode*** predlist=NULL,int* npreds=NULL);
  void delEdge(Cedge *edptr);
  Cnode* getNodeNr(int nodenr);
  
  void compact();
  int getRanks();
  void clear();
  ~Cgraph();
  
  Cverklist< Cnode* > nodes;
  Cverklist< Cedge* > edges;
  
  int maxrank;
  
  protected:
  int comp;
  int nnodenr;
  int specnodes;
  int specedges;
  };
  
#endif
