//****************************************************************************
//
// CCfile: Cgraph.cc
//
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include <stdio.h>
#include "Cgraph.h"
#include "CCexceptions.h"

 
//***************************************************************************
// Implementierung der Klasse: Cgraph
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
//***************************************************************************
template<class N, class E> Cgraph<N,E>::Cgraph()
  {
  comp = 0;
  nnodenr=0;
  }
  
template<class N, class E> 
int Cgraph<N,E>::addNode(Cnode<N,E>* nd)
  {
  int i;
  Cnode<N,E>* ndptr;
  
  if( nd->nodenr == -1 ) // selber Knotennummer suchen
    {
    nd->nodenr = nnodenr;
    comp = comp == nnodenr ? comp+1 : (-1);
    }
  else
    {
    for( ndptr=nodes.skipThru(init) ; ndptr != NULL ; 
         ndptr=nodes.skipThru(next) )
      {
      if( ndptr->nodenr == nd->nodenr )
        {
        return NOVALID_NODE;
        }      
      }
      
    if( nnodenr < nd->nodenr )
        {
        nnodenr = nd->nodenr;
        }
    comp = -1;
    }
      
  nodes.addEl(nd);
  nnodenr++;
  return nd->nodenr;
  }
  
template<class N, class E> 
int Cgraph<N,E>::addEdge(Cedge<E>* ed)
 {
 int i;
 Cnode<N,E> *begn, *endn, *tmp;
 Cedge<E> **eptrptr,*nptr;
 
 //suche Anfangsknoten;
 for( tmp=nodes.skipThru(init),begn=NULL,endn=NULL; 
        !(tmp == NULL || ( begn != NULL && endn != NULL ) ); 
        tmp=nodes.skipThru(next) )
   {
   if( tmp->nodenr == ed->startnode )
     {
     begn=tmp;
     }
   if( tmp->nodenr == ed->endnode )
     {
     endn=tmp;
     }
   }
   
   
 if( endn == NULL || begn == NULL )
   {
   return NOVALID_EDGE;
   }
   
 //zufuegen
 nptr = edges.addEl(ed);
 //nachfolger Verzeigern
 for( eptrptr=&begn->succs ; *eptrptr != NULL ; 
      eptrptr = &(*eptrptr)->next_succ );
 *eptrptr = nptr;
 //vorgaenger
 for( eptrptr=&endn->predecs ; *eptrptr != NULL ; 
      eptrptr = &(*eptrptr)->next_predec );
 *eptrptr = nptr;
 
 }
 
template<class N, class E> 
void Cgraph<N,E>::delNode(int nodenr)
  {
  Cedge<E> *edptr,*rm;
  Cnode<N,E> *ndptr = getNodeNr(nodenr);
  int i;
  
  
  //alle inzidenten Kanten killen
  for( i=0 ; i<edges.getAnzel() ;)
    {
    edptr = &(edges[i]);
    
    if( edptr->startnode == ndptr->nodenr || edptr->endnode == ndptr->nodenr )
      {
      delEdge(edptr);
      }
    else
      {
      i++;
      }
    }
    
  for( i=0 ; nodes[i].nodenr != nodenr ; i++ );
  nodes.delElIndx(i);
  }
  
template<class N, class E> 
Cnode<N,E>* Cgraph<N,E>::getNodeNr(int nodenr)
  {
  int i;
  Cnode<N,E>* ndptr;
  
  if( comp < 0 )
    {
    for( ndptr=nodes.skipThru(init) ; ndptr->nodenr != nodenr ; ndptr=
               nodes.skipThru(next) );
    return ndptr ;
    }
  else
    {
    return &(nodes[nodenr]);
    }
  }


template<class N, class E> 
void Cgraph<N,E>::delEdge(Cedge<E> *eptr)
  {
  int i;
  Cedge<E>* merk,**eptrptr;
  Cnode<N,E> *ndptr;
  
  
  ndptr=getNodeNr(eptr->startnode);
  for( eptrptr= &(ndptr->succs) ; *eptrptr != eptr ; 
       eptrptr = &(*eptrptr)->next_succ );
  *eptrptr=eptr->next_succ;
  
  ndptr=getNodeNr(eptr->endnode);
  for( eptrptr= &(ndptr->predecs) ; *eptrptr != eptr ; 
       eptrptr = &(*eptrptr)->next_predec );
  *eptrptr=eptr->next_predec;

  for( merk=edges.skipThru(init) ; merk != eptr ; merk=edges.skipThru(next) );
  // das naechste Element wird an den Platz des zu loeschenden geschoben  
  merk = edges.skipThru(next);
  
  edges.delElIndx(i);
  
  // wieder zeiger richtig hinbiegen
  // kanten des Verschobenen elemens
  ndptr=getNodeNr(eptr->startnode);
  for( eptrptr= &(ndptr->succs) ; *eptrptr != merk ; 
       eptrptr = &(*eptrptr)->next_succ );
  *eptrptr=eptr;
  
  ndptr=getNodeNr(eptr->endnode);
  for( eptrptr= &(ndptr->predecs) ; *eptrptr != merk ; 
       eptrptr = &(*eptrptr)->next_predec );
  *eptrptr=eptr;
    
  
  }  

template<class N, class E> 
int Cgraph<N,E>::getNextSucc(int ofnode,Cedge<E>** tr)
  {
  int i;
  static int node = -1;
  static Cedge<E> *eptr = NULL;
  Cnode<N,E>* ndptr;

  if( node == -1 )
    {
    for( ndptr=nodes.skipThru(init) ; ndptr->nodenr != ofnode; 
         ndptr=nodes.skipThru(next) );
    if( ndptr==NULL )
      {
      return NOVALID_NODE;
      }
    node = ofnode;    
    eptr = ndptr->succs;
    }
  
  if( eptr == NULL )
    {
    node = -1;
    return NOMORE;
    }
  else
    {
    *tr = eptr;
    eptr=eptr->next_succ;  
    return (*tr)->endnode;
    }
  }

template<class N, class E> 
int Cgraph<N,E>::getNextSucc(int ofnode)
  {
  int i;
  static int node = -1;
  static Cedge<E> *eptr = NULL;
  Cedge<E>* tr;
  Cnode<N,E>* ndptr;
  
  if( node == -1 )
    {
    for( ndptr=nodes.skipThru(init) ; ndptr->nodenr != ofnode; 
         ndptr=nodes.skipThru(next) );
    if( ndptr==NULL )
      {
      return NOVALID_NODE;
      }
    node = ofnode;    
    eptr = ndptr->succs;
    }
  
  if( eptr == NULL )
    {
    node = -1;
    return NOMORE;
    }
  else
    {
    tr = eptr;
    eptr=eptr->next_succ;  
    return tr->endnode;
    }
  }
    
template<class N, class E> 
int Cgraph<N,E>::getNextPred(int ofnode,Cedge<E>** tr)
  {
  int i;
  static int node = -1;
  static Cedge<E> *eptr = NULL;
  Cnode<N,E>* ndptr;
  
  if( node == -1 )
    {
    for( ndptr=nodes.skipThru(init) ; ndptr->nodenr != ofnode; 
         ndptr=nodes.skipThru(next) );
    if( ndptr==NULL )
      {
      return NOVALID_NODE;
      }
    node = ofnode;
    eptr = ndptr->predecs;
    }
  
  if( eptr == NULL )
    {
    node = -1;
    return NOMORE;
    }
  else
    {
    *tr = eptr;
    eptr=eptr->next_predec;  
    return (*tr)->startnode;
    }
  }

template<class N, class E> 
int Cgraph<N,E>::getNextPred(int ofnode)
  {
  int i;
  static int node = -1;
  static Cedge<E> *eptr = NULL;
  Cedge<E>* tr;
  Cnode<N,E>* ndptr;
  
  if( node == -1 )
    {
    for( ndptr=nodes.skipThru(init) ; ndptr->nodenr != ofnode; 
         ndptr=nodes.skipThru(next) );
    if( ndptr==NULL )
      {
      return NOVALID_NODE;
      }
    node = ofnode;
    eptr = ndptr->predecs;
    }
  
  if( eptr == NULL )
    {
    node = -1;
    return NOMORE;
    }
  else
    {
    tr = eptr;
    eptr=eptr->next_predec;  
    return tr->startnode;
    }
  }

template<class N, class E> 
void Cgraph<N,E>::compact()
  {
  Cedge<E> *edptr;
  Cnode<N,E> *ndptr;
  int i;
  for( i=0 ; i<nodes.getAnzel() ; i++ )
    {
    ndptr = &(nodes[i]);
    for( edptr = ndptr->succs ; edptr != NULL ; edptr=edptr->next_succ )
      {
      edptr->startnode = i;
      }
    for( edptr = ndptr->predecs ; edptr != NULL ; edptr=edptr->next_predec )
      {
      edptr->endnode = i;
      }
    ndptr->nodenr =i;
    }
    
  comp = i;
  }
  
template<class N, class E> 
void Cgraph<N,E>::clear()
 {
 nodes.clear();
 edges.clear();
 }

template<class N, class E> 
Cgraph<N,E>::~Cgraph()
  {
  clear();
  }
