//***************************************************************************
//
// Headerfile: Cgraph.h
//
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CGRAPH
#define CGRAPH

#include <stdio.h>
#include "Cverklist.h"

#define NOVALID_EDGE -1
#define NOVALID_NODE -1
#define NOMORE -1

template<class N, class E> class Cnode
  {
  public:
  Cnode() { predecs=NULL; succs=NULL; }
  int nodenr;
  N nodeinfo;
  
  Cedge<E>* predecs;
  Cedge<E>* succs;
  };
  
template<class E> class Cedge
  {
  public:
  Cedge() {next_predec=NULL;next_succ=NULL;};
  int startnode;
  int endnode;
  E edgeinfo;
  
  Cedge<E>* next_predec;
  Cedge<E>* next_succ;
  };
 
//***************************************************************************
// Klassendeklaration: class Cgraph
//
// Autor: A. Kipp
// erstellt: Thu Mar 16 11:06:08 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
template<class N, class E> class Cgraph
  {
  public:
  Cgraph(){};
  
  int addNode(Cnode<N,E>* nd);
  int addEdge(Cedge<E>* ed);
  void delNode(int nodenr);
  void delEdge(Cedge<E> *eptr);
  Cnode<N,E>* getNodeNr(int nodenr);
  int getNextSucc(int ofnode,Cedge<E>** tr);
  int getNextSucc(int ofnode);
  int getNextPred(int ofnode,Cedge<E>** tr);
  int getNextPred(int ofnode);
  void compact();
  void clear();
  ~Cgraph();
  Cverklist< Cnode<N,E> > nodes;
  Cverklist< Cedge<E> > edges;
  
  protected:
  int comp;
  int nnodenr;
  };
  
#endif
