#include <stdio.h>
#include "Cmatrix.h"
#include "Cquad_matrix.h"
#include "Csym_matrix.h"


double z[]={1,-2,3,-4, 3,-2,3,-7, 5,-18,29,-23, 4,-4,0,-29};
double inh[]={0,5,1,-25};
double s[]={1,1,1,1,2,2,2,3,3,4};

main()
  {
  int n;
  Cquad_matrix A(z,4);
  Cvektor i(inh,4);
  Csym_matrix S(s,4);

  Cquad_matrix B = S;
  printf("Matrix S:\n");
  S.printMat();
  
  printf("Matrix B:\n");
  S.printMat();

  Cvektor b = B.solveGlsy(&i);

  for( n=0 ; n<4 ; n++)
    {
    printf("x[%d]=%lf\n",n,b.getVal(n));
    }
  b.clearVek();
  b = S.solveGlsy(&i);

  for( n=0 ; n<4 ; n++)
    {
    printf("x[%d]=%lf\n",n,b.getVal(n));
    }
  }
  

  
