//***************************************************************************
//
// Headerfile: Chgraph.h
//
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CHGRAPH
#define CHGRAPH

#include <float.h>
#include "Cgraph.h"
#include "Cfile_io.h"

#define VARGRAPH_ERRNODES -13
#define VARGRAPH_ERREDGES -14
#define INVALID_SYMB -15
#define KNOT_MASK_W "%d %s %s\n"
#define KNOT_MASK_R "%d %s %n\n"
#define KANT_MASK_W "%d %d %d %s\n"
#define KANT_MASK_R "%d %d %d %n\n"

#define MAXLINELEN 1000

class Chgrnode : public Cnode
  {
  public:
  Chgrnode() { symbol = NULL;addata=NULL;};
  
  char* symbol;
  char* addata;
  };
  
class Chgredge : public Cedge
  {
  public:
  Chgredge() { rulenumber = 0 ; weight=(-1)*DBL_MAX ; addata=NULL;};
  
  int rulenumber;
  double weight;
  char* addata;
  };

//***************************************************************************
// Klassendeklaration: class Chgraph
//
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
class Chgraph : public Cgraph, public Cfile_io
  {
  public:
  Chgraph();
  int readHGraph();
  void writeHGraph();
  int readInventar(char* filename);
  virtual Cnode* newNode() { return new Chgrnode; };
  virtual Cedge* newEdge() { return new Chgredge; };
  virtual int getNodeInfo(Cnode* ndptr,char* info) ;
  virtual void putNodeInfo(Cnode* ndptr,FILE* fp) ;
  virtual int getEdgeInfo(Cedge* edptr,char* info) ;
  virtual void putEdgeInfo(Cedge* edptr,FILE* fp) ;
  void clear();
  ~Chgraph();
  char** inventar;
  
  char* filename;
  char* ortho;
  int anzinv;
  };
  
#endif
