# mausbpf2exb
This program converts speech annotation files in the BAS Partitur Format (BPF) to files for the Partitur-Editor of the EXMARaLDA speech software suite.


## Usage
```
python3 mausbpf2exb.py [-h] [input] [-o OUTPUT] [-v VERBOSITY] [-r REFERENCED_FILE]
                       [--ignore IGNORED_TIER] [--leeway LEEWAY] [--version]
                       [--list-reference-tiers]
```

Both INPUT and OUTPUT are optional arguments.
	If INPUT is not specified, STDIN will be used, allowing for piping.
	If OUTPUT is not specified, it will be printed to STDOUT, also allowing for piping.
	
-v/--verbosity is the verbosity level. The default is 0.

Both .par files and .exb files are sidecar files. If you wish for EXMARaLDA to include the audio file that the .exb file annotates in the Partitur-Editor, you may need to specify it with with the -r/--referenced-file option.

If you wish to exclude certain tiers from the conversion, you can specify them with the --ignore option.

--leeway specifies minimum distance (in number of samples) which two timeline items in the .exb file have to be apart in order to be regarded as distinct items (default = 5). If below the threshold, the items will be merged.

--version prints the version number and exits.

--list-reference-tier prints the hierarchy of class 4 tiers used to infer times of symbolic links and exit

You can print a detailed help message using `python3 mausbpf2exb.py --help`


## Remarks
Currently all tiers except class 3 tiers are supported. Tiers containing semicolon-separated symbolic links are also unsupported.

### TODO
- encode additional .par header information in .exb ud-information
- add warning if user chooses to ignore a tier but the tier isn't present anyway
- add error if there's an unknown BPF tier

### Known bugs
- occasionally a tier item in the output .exb will appear with a length of only one sample. This usually happens across tiers and not on the same tier
