//***************************************************************************
//
// CCFile: iotoolbox.cc
//
// Autor: A.Kipp
// erstellt: veraendert:
//
// Enthaelt: routinen zum einlesen und ausgeben von datenfiles
//***************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include "iotoolbox.h"
extern "C" {
#include "ipkclib.h"
}

#define SPACES " \n\t"

long read_phondat_speechfile(char* name, short** sbufptr)
{
  FILE* fp;
  long nofbytes,merker;
  Phon_header_2 *header;
  char *orth=NULL,*kan=NULL;
  

  if( (fp = fopen(name,"rb")) == NULL )
    {
      return -1;
    }

  // Phondat-header
#ifdef SUN
  if( (header =  read_header_sun(fp,&orth,&kan)) == NULL ) 
#endif
#ifdef LINUX
    if( (header=      read_header_vms(fp,&orth,&kan)) == NULL ) 
#endif  
      {
	return -1;
      }
    
  // laenge feststellen
  merker = ftell(fp);
  fseek(fp,0L,SEEK_END);
  nofbytes =ftell(fp) - merker;
  fseek(fp,merker,SEEK_SET);

  // buffer alloziieren
  (char*)(*sbufptr) = new char[nofbytes];
  if( *sbufptr == 0 )
    {
      fprintf(stderr,"Out of Mem %s line %d\n",__FILE__,__LINE__);
      return -2;
    }

  // einlesen
  if( fread((char*)(*sbufptr),sizeof(char),nofbytes,fp) != nofbytes )
    {
      fprintf(stderr,"Read error\n");
      return -3;
    }
#ifdef SUN
  // swappen
  register char* cp, temp;
  int n;
    
  cp= (char*)(*sbufptr);

  for(n=0 ; n< nofbytes/2 ; n++) // unbedingt noch als inline-fkt
    {
      temp=cp[0];
      cp[0]=cp[1];
      cp[1]=temp;
      cp+=2;
    }
#endif

  fclose(fp);
  // platz freigeben
  free( (char*)header );
  free( (char*)orth);
  free( (char*)kan);
  return nofbytes/2;
}

FILE* open_phondat_speechfile(char* name)
{
  FILE* fp;
  Phon_header_2 *header;
  char *orth,*kan;
  

  if( (fp = fopen(name,"rb")) == NULL )
    {
      return NULL;
    }

  // Phondat-header
  if( (header = read_header_sun(fp,&orth,&kan)) == NULL )
    {
      return NULL;
    }

  free( (char*)orth);
  free( (char*)kan);
   
  return fp;
}

int read_phondat_label_file(char* name,struct phondatlabelinf* plinf)
{
  FILE* fp;
  Phondat_Label *lrp = new Phondat_Label;
  char* buf,*cp1,*cp2;
  
  if( (fp=fopen(name,"r")) == NULL )
    {
      return (-1) * __LINE__;
    }
    
  //lese file ein
  fseek(fp,0,2);
  long len = ftell(fp);
  rewind(fp);
  buf = new char[len];
  
  if( fread(buf,1,len,fp) != len )
    {
      return -1 * __LINE__;
    }
   
  //filename
  if( (cp1 = strchr(buf,'\n')) == NULL )
    {
      return -1 * __LINE__;
    }
  
  plinf->filename = new char[++cp1-buf];
  sscanf(buf,"%s",plinf->filename);
  cp1 += strspn(cp1,SPACES); 

  //ortho
  if( (cp2 = strstr(cp1,"oend")) == NULL )
    {
      cp2=cp1;
    } 
  else
    {
      plinf->ortho = new char[cp2-cp1+1];
      memcpy(plinf->ortho,cp1,cp2-cp1);
      plinf->ortho[cp2-cp1]='\0';
      cp1 = cp2 + strlen("oend");
      cp1 += strspn(cp1,SPACES);
    }
  
  //kano
  if( (cp2 = strstr(cp1,"kend")) == NULL )
    {
      cp2 = cp1;
    } 
  else
    {
      plinf->kano = new char[cp2-cp1+1];
      memcpy(plinf->kano,cp1,cp2-cp1);
      plinf->kano[cp2-cp1]='\0';
      cp1 = cp2 + strlen("kend");
      cp1 += strspn(cp1,SPACES);
    }
    
  //kano
  if( (cp2 = strstr(cp1,"hend")) == NULL )
    {
      cp2 = cp1;
    } 
  else
    {
      plinf->h = new char[cp2-cp1+1];
      memcpy(plinf->h,cp1,cp2-cp1);
      plinf->h[cp2-cp1]='\0';
      cp1 = cp2 + strlen("hend");
      cp1 += strspn(cp1,SPACES);
    }
  
  do
    {
      if( sscanf(cp1,"%d %s %lf",&lrp->start,lrp->lab,&lrp->score) > 2 )
	{
	  plinf->lablist.addEl(&lrp);
	  lrp = new Phondat_Label;
	}
    }while( (cp1 = strchr(cp1,'\n')) != NULL && ((++cp1) - buf) < len );
    
  delete [] buf;
  delete lrp;
  fclose(fp);
  return 1;
}
  
void swap_short(short* s,int anz)
{
  // swappen
  register char* cp, temp;
  register int n;
    
  cp= (char*)s;

  for(n=0 ; n< anz ; n++) // unbedingt noch als inline-fkt
    {
      temp=cp[0];
      cp[0]=cp[1];
      cp[1]=temp;
      cp+=2;
    }
}

int write_phondat_label_file(char* name,struct phondatlabelinf* plinf)
{
  FILE* fp;
  Phondat_Label** lrpp;
  
  if( (fp=fopen(name,"w")) == NULL )
    {
      return (-1) * __LINE__;
    }
    
  fprintf(fp,"%s\n",plinf->filename);
  fprintf(fp,"%s",plinf->ortho);
  fprintf(fp,"oend\n");
  fprintf(fp,"%s",plinf->kano);
  fprintf(fp,"kend\n");
  fprintf(fp,"%s",plinf->h);
  fprintf(fp,"hend\n");
  
  for(lrpp=plinf->lablist.skipThru(init) ; lrpp!=NULL ; 
      lrpp = plinf->lablist.skipThru(next))
    {
      fprintf(fp,"\t %ld %s %lf\n",(*lrpp)->start,(*lrpp)->lab,(*lrpp)->score);
    }
    
  fclose(fp);
  return 1;
}
  
int info_from_phondatfilename(char* phdname,char* spkr,char* ortsk,int *num)
{
  //strip off trailing pathname
  char* cp = phdname;
  
  if( (cp=strrchr(cp,'/'))==NULL )
    {
      cp=phdname;
    }
  else
    {
      cp++;
    }
    
  if( strlen(cp) < 8 )
    {
      return -1;
    }
    
  strncpy(spkr,cp,3);
  spkr[3]='\0';
  *ortsk=cp[3];
  if( !sscanf(cp+4,"%d.",num) )
    {
      return -1;
    }
    
  *num/=10;
  return *num;
} 


int readInventar(char* filename,char*** ppp_inventar)
{
  FILE* fp;
  Cverklist<char*> v_invlist;
  char* cp;
  char line[100];
  int anzinv = -1;
  
  if( (fp = fopen(filename,"r")) == NULL)
    {
      return -1 ;
    }
  
  while( fgets(line,100,fp) != NULL )
    {
      cp = strchr(line,'\n');
	  if( cp != NULL )
        {
          *cp = '\0';
        }
      cp = strdup(line);
      v_invlist.addEl(&cp);
    }
    
  anzinv=v_invlist.compact(ppp_inventar);
  v_invlist.clear();
  return anzinv;
}


void fnbody(char* name,char* target)
{
  char* cp = strrchr(name,'/');
  if( cp == NULL )
    {
      cp=name;
    }
  else
    {
      cp++;
    }

  sprintf(target,"%s",cp);
  char* term = strchr( target ,'.');
  if( term != NULL )
    {
      *term='\0';
    }

}

void lobotomo(char* name,char* path,char* body,char* ext)
{
  char* fn = strdup(name);

  char* ap = fn;
  char* cp = strrchr(ap,DIRSEP);

  if( cp != NULL )
    {
      *cp = '\0';
      sprintf(path,"%s",ap);
      ap = cp+1;
    }
  else
    {
      path[0]='\0';
    }

  cp = strrchr(ap,EXTSEP);

  if( cp != NULL )
    {
      *cp = '\0';
      sprintf(body,"%s",ap);
      ap = cp+1;
    }
  else
    {
      //ignore hidden files
      ext[0] = '\0';
      sprintf(body,"%s",ap);
      return;
    }

  sprintf(ext,"%s",ap);
}

  

