//****************************************************************************
//
// CCfile: Cverklist.cc
//
// Autor: A. Kipp
// erstellt: Wed Mar  1 10:20:59 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include "Cverklist.h"
#include "CCexceptions.h"

//***************************************************************************
// Implementierung der Klasse: Cverklist
// Autor: A. Kipp
// erstellt: Wed Mar  1 10:20:59 1995 
// veraendert:
//***************************************************************************
template<class T> Cverklist<T>::Cverklist()
  {
  anzel = 0;
  addhere = &anker;
  anker = NULL;
  acsptr = NULL;
  }
  
template<class T> T* Cverklist<T>::addEl(T* el)
  {
  T* ptr;
  *addhere = new Clistel<T>;
  if( *addhere == 0 )
    {
    failure(__FILE__,__LINE__,"Outa Memory");
    }
    
  memcpy( (char*)(&(*addhere)->data),(char*)el,sizeof(T));
  ptr = &(*addhere)->data;
  addhere = &(*addhere)->next;
  anzel++;
  return ptr;
  }

template<class T> T* Cverklist<T>::addElIndx(T* el,int index)
  {
  T* ptr;
  int i;
  Clistel<T> **akt = &anker;
  
  for( i=0 ; i<index && *akt != NULL; i++, akt=&(*akt)->next );
   
  if( *akt == NULL )
    {
    return addEl(el);
    }
    
  Clistel<T> *nel = new Clistel<T>;
  if( nel == 0 )
    {
    failure(__FILE__,__LINE__,"Outa Memory");
    }
    
  memcpy( (char*)(&nel->data),(char*)el,sizeof(T));
  ptr = &nel->data;
  nel->next=*akt;
  *akt=nel;
  anzel++;
  return ptr;
  }

template<class T> T* Cverklist<T>::addIniEl(T* el)
  {
    addElIndx(el,0);
  }  
template<class T>  void Cverklist<T>::delElIndx(int index)
  {
  int i;
  Clistel<T> *akt = anker;
  for( i=0 ; i<index && akt != NULL; i++,akt=akt->next );
   
  if( akt == NULL )
    {
    failure(__FILE__,__LINE__,"Range exceeded");
    }
    
  deleteVlistEl(akt);
  }
  
template<class T> Cverklist<T>::~Cverklist()
{
  clear();
}

template<class T> void Cverklist<T>::clear()
  {
  Clistel<T>* rmnext;
  
  for( ;anker != NULL ; )
    {
    rmnext = anker->next;
    delete anker;
    anker = rmnext;
    }
  anker = NULL;
  anzel = 0;
  addhere = &anker;
  }

template<class T> void Cverklist<T>::deleteVlistEl(Clistel<T>* le)
  {
  Clistel<T>* rm = le->next;
  int i;
  if( rm != NULL )
    {
    memcpy( (char*)(le) , (char*)(rm) , sizeof(Clistel<T>));
    delete rm;
    }
  else
    {
    delete le;
    //addhere richten    
    }
  
  anzel--;
  for( addhere=&anker, i=0 ; i < anzel ; addhere = &((*addhere)->next),i++ );
  *addhere = NULL;
  }

template<class T>  T* Cverklist<T>::skipThru(vlist_cntl cntl,
                                    Clistel<T>** skipvar)
  {
  
  if( skipvar == NULL )
    {
    skipvar = &acsptr;
    }
    
  switch( cntl )
    {
    case init:
      *skipvar = anker;
      break;
      
    case next:
      if( *skipvar == NULL )
        {
        failure(__FILE__,__LINE__,"wrong skip-through nesting");
        }
        
      *skipvar =  (*skipvar)->next;
        
      break;
    }
    
  return *skipvar == NULL ? NULL : &((*skipvar)->data);
  }

template<class T> T& Cverklist<T>::operator[](int index)
  {
  int i=0;
  Clistel<T> *akt = anker;
  
  for( i=0,akt=anker ; i<index ; i++,akt=akt->next )
    {
    if( akt == NULL )
      {
      failure(__FILE__,__LINE__,"Range exceeded");
      }
    }
  return akt->data;
  }
 
template<class T> int Cverklist<T>::compact(T** ptr)
  {
  int i;
  Clistel<T> *akt = anker;
  *ptr = new T[anzel];
  
  if( *ptr == 0 )
    {
    failure(__FILE__,__LINE__,"Outa Memory");
    }
    
  for( i=0 ; akt != NULL ; akt=akt->next,i++ )
    {
    memcpy( (char*)(*ptr + i) , (char*)(&akt->data) , sizeof(T));
    }
    
  return anzel;
  }
