//************************-*-c++-*-***************************************
//
// Headerfile: Cgraphvis.h
//
// Autor: A. Kipp
// erstellt: Wed Apr 17 10:46:20 1996 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CGRAPHVIS
#define CGRAPHVIS
#include <Xm/Xm.h>

#include "Chgraph.h"
#include "Cpsout.h"

struct kanal
{
  kanal(int len) { occupied = new char[len]; memset(occupied,0,len);};
  ~kanal() { delete [] occupied; };
  int ky;
  char* occupied;
};

class Cgraphvisnode : public Chgrnode
{
public:
  Cgraphvisnode() { };
  XPoint loc;
};

class Cgraphvisedge : public Chgredge
{
public:
  Cgraphvisedge() { pts=NULL;npts=0;};
  XPoint* pts;
  int npts;
};
#define NODEDIST 150

#define KANANZ 3

//***************************************************************************
// Klassendeklaration: class Cgraphvis
//
// Autor: A. Kipp
// erstellt: Wed Apr 17 10:46:20 1996 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
class Cgraphvis : public Chgraph
{
  public:
  Cgraphvis(int nd = NODEDIST,int ka = KANANZ);

  int calculate();
  int initDrawing(char** argv,int* argcp);
  void draw(XmDrawingAreaCallbackStruct* dainfo);
  int psOut(char* filename);
  void run();
  void  setGC(Pixel fog,Pixel bag,int function);
  virtual Cnode* newNode();
  virtual Cedge* newEdge();
  Cgraphvis::~Cgraphvis();

  Cpsout *psout;
  int pages;
  int eps;

  protected:
  int ndanz;
  Cnode** ndlist;
  Cverklist<kanal*> kanaele;

  int nodedist;
  int kandist;
  int kananz;


  XtAppContext app;
  Widget toplevel;
  Widget mainwin;
  Widget drawar;

  int width;
  int height;

  GC gc;
  XGCValues werte;
  unsigned long maske;
  Pixel fg,bg;
  XFontStruct *fontinfo;

};

#endif
