/* ************** HEADER FOR PROJECT createvar  *************************

Name: gen_lexvar-1.0.h
Date: 20.02.1995 / 3.03.1995

**************************************************************************/
#ifndef GEN_LEXVAR
#define GEN_LEXVAR
#ifndef FILE
#include <stdio.h>
#include <string.h>
#include <ipkclib.h>
#endif 

/* preprocessor constants used by more than one module of the project or by 
modules from other projects (listed with sorted module names)		*/

#define TRUE 1
#define FALSE 0
#define EIN '<'			/* Symbol fuer Eingangsknoten			*/
#define AUS '>'			/* Symbol fuer Ausgangsknoten			*/
#define KANONISCHE_FORM 0	/* Regelnummer fuer kanonische Form		*/
#define VOR_KNOTEN '!'		/* Trennsymbol vor Knoten			*/
#define VOR_KANTEN '&'		/* Trennsymbol vor Kanten			*/
#define VOR_NEXTORTHO '*'	/* Trennsymbol vor naechstem lex. Eintrag	*/
#define KNOTOUTPUT    	"%d %c\n" 		/* Ausgabeformat fuer Knoten 	*/
#define EDGEOUTPUT	"%d %d %d\n"	/* Ausgabeformat fuer Kanten	*/


/*######################################################################*/

/* type definitions used by more than one module of the project or can be 
used by other functions (listed with sorted module names)		*/


/*-----Strukturdefinition fuer Graph-----*/

typedef struct knot
   {
   int knotnumber;		/* Knotennummer, jeder K. hat eigene Nr	*/
   char symbol[5];		/* zugehoeriges SAMPA-Symbol			*/
   struct knot *next_knot;	/* Pointer auf naechsten Knoten		*/
   }Knot;

typedef struct edge
   {
   int from_knot;			/* Nummer des Vorgaengerknotens		*/
   int to_knot;			/* Nummer des Nachfolgeknotens		*/
   int rulenumber;		/* Regel, durch die edge erzeugt wurde	*/
   struct edge *next_edge;	/* Pointer auf naechste Kante			*/
   }Edge;

typedef struct graph		/* Anker der beiden Listen 			*/
   { 
   Knot *first_knot;		/* zeigt auf Adresse des ersten Knoten	*/
   Edge *first_edge;		/* zeigt auf Adresse der ersten Kante	*/
   }Graph;




/* #####################################################################*/

/* function prototypes	(listed with sorted module names)		*/

int read_canonic_form(FILE *fplexicon, char ortho[], char canonic_form[]);
void make_canonic_graph(char *transcript_ptr, Graph *canonic_form_ptr);
void write_on_stdout(char ortho[], Graph *canonic_form_ptr);
int read_rule(FILE *fprule_corpus, char rule[]);

#endif