//****************************************************************************
//
// CCfile: Cvargraph.cc
//
// Autor: A. Kipp
// erstellt: Tue Mar 21 15:03:37 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include <math.h>
#include "Cvargraph.h"
#include "CCexceptions.h"

#define READ_FILENAME 0
#define READ_ORTHO 1
#define READ_NODES 2
#define READ_EDGES 3

#define VARGRAPH_ENTMASK "##entropy=%lf"
#define VARGRAPH_PATHMASK "##npath=%lf"

//***************************************************************************
// Implementierung der Klasse: Cvargraph
// Autor: A. Kipp
// erstellt: Tue Mar 21 15:03:37 1995 
// veraendert:
//***************************************************************************
Cvargraph::Cvargraph()
  {
    entropy=0.0;
    pathes=0.0;
    specCvar(VARGRAPH_ENTMASK,&entropy,0);
    specCvar(VARGRAPH_PATHMASK,&pathes,0);
  }


////////////////////////////////////////////////////////////////////////////////
//
// Funktion: C
//
// Parameter: void
//
// Beschreibung: Liest den Graph ein
// und baut ihn auf.  
////////////////////////////////////////////////////////////////////////////////
Cnode* Cvargraph::newNode() 
  {
  Cnode* nd = new Cvgrnode;
  return nd;
  }

Cedge* Cvargraph::newEdge()
  {
  Cedge* ed = new Cvgredge;
  return ed;
  }
double Cvargraph::entCalc()
{
  int i,maxrank;
  Cvgrnode* vgrnode;
  Cedge** edptrptr;
  Cnode** ndlist;
  int ndanz;

  entropy=0.0;
  pathes=0.0;
  double norm = 1/log(2);
  double sumwkt;
  
  maxrank = getRanks();
  if( maxrank < 0 )
    {
      warning(__FILE__,__LINE__,"failed to get ranks");
      return -1;
    }
  ndanz = nodes.compact(&ndlist);
  qsort((char*)ndlist,ndanz,sizeof(Cnode*),compranks);

  for( i=0; i<ndanz ; i++ )
    {
      //check consistency
      vgrnode = (Cvgrnode*)ndlist[i];
      sumwkt=0.0;
      for( edptrptr=vgrnode->succs.skipThru(init) ; 
	   edptrptr!=NULL ;
	   edptrptr=vgrnode->succs.skipThru(next) )
	{
	  sumwkt += exp( (*edptrptr)->log_uewkt );
	}
      if(  vgrnode->succs.getAnzel() > 0 &&
					 (sumwkt > 1.001 || sumwkt < 0.999 ))
	{
	  warning(__FILE__,__LINE__,"Transprobs wrong: %lf (%s : node %d)",
		  sumwkt,filename==NULL? "(nul)" : filename,vgrnode->nodenr);
	}
	  
      if( vgrnode->rank == 0 )
	{
	  vgrnode->entropy=0.0;
	  vgrnode->numpath=1;
	  vgrnode->log_wkt=0;
	}
      else
	{
	  sumwkt=0.0;
	  vgrnode->entropy = 0.0;
	  for( edptrptr=vgrnode->predecs.skipThru(init) ; 
	       edptrptr!=NULL ;
	       edptrptr=vgrnode->predecs.skipThru(next) )
	    {
	      vgrnode->entropy += exp( (*edptrptr)->log_uewkt ) *
		( exp( ((Cvgrnode*)((*edptrptr)->startnode))->log_wkt  ) 
                  * (*edptrptr)->log_uewkt +
                  ((Cvgrnode*)((*edptrptr)->startnode))->entropy );
	      vgrnode->numpath += 
		((Cvgrnode*)((*edptrptr)->startnode))->numpath;
	      // assure node-scores are correct
	      sumwkt += exp(((Cvgrnode*)((*edptrptr)->startnode))->log_wkt +
			    (*edptrptr)->log_uewkt );
	    }
	  if( sumwkt > 1.0 + 1e-5 )
	    {	      warning(__FILE__,__LINE__,
		      "internal error: sum of p = %lf (nodenr %d)\n",
		      sumwkt,vgrnode->nodenr);
	      return 0.0;
	    }
	  vgrnode->log_wkt = log( sumwkt );
	  //if node is a sublattice, add its entropy
	  vgrnode->entropy -= vgrnode->sublatentropy * sumwkt;
	}

      if( vgrnode->succs.getAnzel() == 0 )
	{
	  entropy -= vgrnode->entropy;
	  pathes += vgrnode->numpath;
	}
    }
  entropy *= norm;
  return entropy;
}

	    

  
