//****************************************************************************
//
// CCfile: word_var_main.cc
//
// Autor: A. Kipp
// erstellt: Tue Mar 21 14:39:10 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "CrlkontWordVar.h"
#include "CCexceptions.h"
#include "icsiargs.h"

//extern "C" {
//#include "ipkclib.h"
//}


#define REGELFILE "/home/kip/projekte/autoseg/erg/regeln/regeln8.ges.clean"
#define INVENTAR "/home/verbmobil/softw/autoseg/symbol-inventar.txt"
#define VERSION "2.0"

main(int argc,char** argv)
{
  FILE* fp,*fpout=stdout,*fpin=stdin;
  char *rfile=NULL, *ivfile=NULL, *ifile=NULL , *odir=NULL;
  char* appname;
  int i;
  double jumpwk=0.5;
  double monoback=-1.0;
  int jokers=0;
  char* wwtype = "mpv";
  CwordVar *wordvar;
  
  icsiargtab_t args[] =
  {
    {"rg","regel-file (binaer)",ARG_STR,&rfile},
    {"iv","inventar-file",ARG_STR,&ivfile},
    {"if","input (kan. Form)",ARG_STR,&ifile},
    {"odir","output dir",ARG_STR,&odir},
    {"wwt","wordvartyp",ARG_STR,&wwtype},
    {"jwk","pausenuebersprwk",ARG_DOUBLE,&jumpwk},
    {"mb","monbackwk",ARG_DOUBLE,&monoback},
    {"jokers","joker-nodes(with monoback only)",ARG_BOOL,&jokers},
    {0,0,ARG_NOMOREARGS}
  };
  
  
  try
    {
    // Start of code
    icsiargs(args,&argc,(const char***)&argv,&appname);
    if( rfile == NULL )
      {
      rfile = strdup(REGELFILE);
      }
      
    if( ivfile == NULL )
      {
      ivfile = strdup(INVENTAR);
      }
   
    if( !strcmp(wwtype,"mpv") )
      {
	wordvar = new CrlkontWordVar;
      }
    else
      {
	wordvar = new CwordVar;
      }
    wordvar->jumpwk = jumpwk;
    wordvar->monoback = monoback;
    wordvar->jokers = jokers;

    if( wordvar->vargraph->readInventar(ivfile) < 0 )
      {
      failure(__FILE__,__LINE__,"Error reading inventar ");
      }

    if( wordvar->readRegeln(rfile) < 0 )
      {
      failure(__FILE__,__LINE__,"Error reading rules ");
      }
      
    // input output setzen falls noetig
    if( ifile != NULL )
      {
      fpin = fopen(ifile,"r");
      if( fpin == NULL )
        {
        fprintf(stderr,"Warning: couldn't open %s. using default\n",ifile);
        }
      else
        {
        wordvar->setIn(fpin);
        }
      }
    
    if( odir != NULL )
      {
	wordvar->workdir = odir;
      }

      
    // Steuerroutine
    wordvar->run();
    
    // End of code 
    }
  catch(Ausnahme& a)
    {
    switch( a.code )
      {
      default:
      fprintf(stderr,"%s\n",a.message);
      exit(1);
      }
    }
  catch(...)
    {
    exit(2);
    }
  }

