//****************************************************************************
//
// CCfile: graphvis.cc
//
// Autor: A. Kipp
// erstellt: Wed 17.04 14:39:10 1996 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "Cgraphvis.h"
#include "CCexceptions.h"

/*
extern "C" {
#include "ipkclib.h"
}*/

#include "Cdocsys.h"

#define INVENTAR "/home/kip/projekte/vorschlagstrans/inventar.txt"

main(int argc,char** argv)
  {
  FILE *fpin=stdin;
  char  *ifile=NULL, *ivfile=NULL;
  char *psoutfile=NULL;
  int eps=0;
  char* appname;
  int i;
  int nodedist = NODEDIST,kananz=KANANZ,pages=1;
  
  icsiargtab_t args[] =
  {
    {"if","input (kan. Form)",ARG_STR,&ifile},
    {"iv","inventar-file",ARG_STR,&ivfile},
    {"ps","psout-file",ARG_STR,&psoutfile},
    {"nd","distanz zw. Knoten",ARG_INT,&nodedist},
    {"ka","Anzahl Kanaele",ARG_INT,&kananz},
    {"pa","Anzahl PS-Seiten",ARG_INT,&pages},
    {"eps","eps-output",ARG_BOOL,&eps},
    {0,0,ARG_NOMOREARGS}
  };
  
  
  try
    {
    // Start of code
    icsiargs(args,&argc,(const char***)&argv,&appname);
    Cgraphvis vis(nodedist,kananz);
    vis.eps=eps;

    // input output setzen falls noetig
    if( ifile != NULL )
      {
      fpin = fopen(ifile,"r");
      if( fpin == NULL )
        {
        fprintf(stderr,"Warning: couldn't open %s. using default\n",ifile);
	free(ifile);
	ifile = NULL;
	fpin = stdin;
        }
      }

    if( ivfile == NULL )
      {
	ivfile = strdup(INVENTAR);
      }
          
    if( vis.readInventar(ivfile) < 0 )
      {
	failure(__FILE__,__LINE__,"Error reading inventar ");
      }

    vis.setIn(fpin);
    if( vis.readHGraph() < 0 )
      {
	failure(__FILE__,__LINE__,"Error reading graph from %s",
		ifile == NULL ? "stdin" : ifile);
      }
    // Steuerroutine
    vis.initDrawing(argv,&argc);

    vis.calculate();
    if( psoutfile != NULL )
      {
	vis.pages = pages;
	vis.psOut(psoutfile);
      }
    else
      {
	vis.run();
      }
    // End of code 
    }
  catch(Ausnahme& a)
    {
    switch( a.code )
      {
      default:
      fprintf(stderr,"%s\n",a.message);
      exit(1);
      }
    }
  catch(...)
    {
    exit(2);
    }
  }
