# mausbpf2exb
This program converts speech annotation files in the BAS Partitur Format (BPF) to files for the Partitur-Editor of the EXMARaLDA speech software suite.


## Usage
```
python3 mausbpf2exb.py [input] [-o OUTPUT] [-v VERBOSITY] [-r REFERENCED_FILE]
                       [--ignore IGNORED_TIER] [--leeway LEEWAY] [--version]
                       [--list-reference-tiers] [--help]
```

Both INPUT and OUTPUT are optional arguments.
	If INPUT is not specified, STDIN will be used, allowing for piping.
	If OUTPUT is not specified, it will be printed to STDOUT, also allowing for piping.
	
-v/--verbosity is the verbosity level for debug information. The default is 0, meaning that only errors and warnings will be displayed, but no debug information.

Both .par files and .exb files are sidecar files. If you wish for EXMARaLDA to include the audio file that the .exb file annotates in the Partitur-Editor, you may need to specify it with with the -r/--referenced-file option.

If you wish to exclude certain tiers from the conversion, you can specify them with the --ignore option.

--leeway specifies minimum distance (in number of samples) which two timeline items in the .exb file have to be apart in order to be regarded as distinct items (default = 5). If below the threshold, the items will be merged.

--version prints the version number and exits.

--list-reference-tier prints the hierarchy of class 4 tiers used to infer times of symbolic links and exits.

-h/--help prints a help message similar to this readme and exits.


## Remarks
Currently all tiers except class 3 tiers are supported. Tiers containing semicolon-separated symbolic links are also unsupported.
If the input contains any class 1 or class 5 tiers (which it usually does), the program will cycle through a hierarchy of selected class 4 tiers (see --list-reference-tiers) and use the first one it finds to infer the times of the symbolic links. If there is not at least one of these tiers present which contains a reference to every symbolic link (and provided the reference is a singular link, not a comma or semicolon-separated list of links), the file cannot be converted. However, you can instead choose to discard all class 1 and class 5 tiers; for this, run the program once with your input, the resulting error message will tell you exactly which option you will have to use to do so.


## Known bugs
- occasionally a tier item in the output .exb will appear with a length of only one sample. This usually happens across tiers and not on the same tier
