//***************************************************************************
//
// Headerfile: Cmatrix.h
//
// Autor: A.Kipp
// erstellt: veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CMATRIX
#define CMATRIX

#define CMATRIX_NOQUAD -1
#define CMATRIX_DET0 -2
#define CMATRIX_SOLVED 1

#include "Cvektor.h"

//***************************************************************************
// Klassendeklaration: Cmatrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
// Kurzbeschreibung: Basisklasse fuer Matrizen
//***************************************************************************

class Cmatrix
  {
  public:
  Cmatrix(Cvektor* p_row, int nr);
  Cmatrix(double* data,int nr, int nc);
  Cmatrix(int nr, int nc);
  // do-nothing-Konstruktor
  Cmatrix() : num_of_rows(0),num_of_cols(0),pp_row(NULL),mem(0){};
  // copy-Konstruktor
  Cmatrix(Cmatrix& mat);
  
  // info ueber Matrix
  int getNRows() { return num_of_rows; };
  int getNCols() { return num_of_cols; }; 

  virtual double getVal(int r, int c) { return pp_row[r]->getVal(c); };
  virtual void setVal(int r, int c, double l) { pp_row[r]->setVal(c,l); };
  virtual void incVal(int r, int c, double l) { pp_row[r]->incVal(c,l); };
  virtual void decVal(int r, int c, double l) { pp_row[r]->decVal(c,l); };
  void clearMat();


  void Cmatrix::printMat();
  double* getDataPtr() { return data;};
  
  // Operatoren
  Cvektor Cmatrix::operator*(Cvektor& vek);
  Cmatrix Cmatrix::operator*(Cmatrix& mat);
  Cmatrix& operator=( Cmatrix& mat);
  virtual ~Cmatrix();

  protected:
  double* data;
  Cvektor** pp_row;
  int num_of_rows;
  int num_of_cols;
  short mem;
  };

// abgeleitete Klassen
class Cquad_matrix;
class Csym_matrix;

#endif
 

