//****************************************************************************
//
// CCfile: Chgraph.cc
//
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "Chgraph.h"
#include "CCexceptions.h"
#include <math.h>
#include <stdlib.h>
#include <string.h>

extern "C" {
extern char* strtok_r(char* ,const char* ,char** );
}

#define READ_FILENAME 0
#define READ_ORTHO 1
#define READ_NODES 2
#define READ_EDGES 3

char* wordseps[] = {"#","&",NULL};



//***************************************************************************
// Implementierung der Klasse: Chgraph
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
//***************************************************************************
Chgraph::Chgraph()
{
  inventar = NULL;
  anzinv = 0;
  filename = NULL;
  specString(HGRAPH_FILENAMEMARK,&filename,1);
  specClist(HGRAPH_ORTHOMASK,&ortho,0);
  setEndMark(HGRAPH_ENDHEADMARK);
}
  
  
////////////////////////////////////////////////////////////////////////////////
//
// Funktion: Chgraph::readHypGraph
//
// Parameter: void
//
// Beschreibung: Liest den Graph ein
// und baut ihn auf.  
////////////////////////////////////////////////////////////////////////////////
int Chgraph::readHGraph() 
{
  return readGraph(in);
}

void Chgraph::writeHGraph()
{
    
  writeGraph(out);
}
 
int Chgraph::readInventar(char* filename)
{
  FILE* fp;
  Cverklist<char*> v_invlist;
  char* cp;
  char line[100];
  
  if( (fp = fopen(filename,"r")) == NULL)
    {
      return -1 ;
    }
  
  while( fgets(line,100,fp) != NULL )
    {
      if( sscanf(line,"%s",line) == 1 )
	{
	  cp = strdup(line);
	}
      v_invlist.addEl(&cp);
    }
    
  anzinv=v_invlist.compact(&inventar);
  return anzinv;
} 

Cedge* Chgraph::addEdge(Cedge* ed,Cnode* begn,Cnode* endn)
 {
 int i;
 Cnode **tmp;
 Cedge* inep;
 Clistel<Cnode*> *skipvar;
 
 //gibt es die Kante schon
 if( (inep = isIn(ed == NULL ? begn : ed->startnode,
		  ed == NULL ? endn : ed->endnode)) != NULL )
   {
     if( ed != NULL )
       {
	 delete ed;
       }
     ed = inep;
     return inep;
   }
 else
   {
     return Cgraph::addEdge(ed,begn,endn);
   }
 }


int Chgraph::setNode(Cnode* ndptr,char* key,char* value)
{

  Chgrnode* hgndp = (Chgrnode*)ndptr;

  if( !strcmp("W",key) )
    {
      hgndp->symbol = strdup(value);
    }
  else if( !strcmp("wn",key) )
    {
      hgndp->wordnum = atoi(value);
    }
  else if( !strcmp("rn",key) )
    {
      hgndp->rulenumber = atoi(value);
    }
  Cgraph::setNode(ndptr,key,value);
}

int Chgraph::setEdge(Cedge* edptr,char* key,char* value)
{
  Chgredge* hgedp = (Chgredge*)edptr;

  if( !strcmp("l",key) )
    {
      hgedp->log_uewkt = atof(value);
    }
  else if( !strcmp("rn",key) )
    {
      hgedp->rulenumber = atoi(value);
    }
  Cgraph::setEdge(edptr,key,value);

}

Cnode* Chgraph::addNode(Cnode* ndptr)
{
  Chgrnode* hgndp = (Chgrnode*)ndptr;
  // perform specific checks..
  return Cgraph::addNode(ndptr);
}
  
char* Chgraph::putNodeInfo(Cnode* ndptr,char* target)
{
  target = Cgraph::putNodeInfo(ndptr,target);
  char kvp[100];

  Chgrnode* hgndp = (Chgrnode*)ndptr;
  sprintf(kvp,"W=%s",hgndp->symbol);
  sprintf(target," %s",kvp);
  target+=strlen(kvp)+1;
  if( hgndp->rulenumber >= 0 )
    {
      sprintf(kvp,"rn=%d",hgndp->rulenumber);
      sprintf(target," %s",kvp);
      target += strlen(kvp) + 1;
    }
  return target;
}
    
char* Chgraph::putEdgeInfo(Cedge* edptr,char* target)
{
  char kvp[100];
  Chgredge* hgedp = (Chgredge*)edptr;

  target = Cgraph::putEdgeInfo(edptr,target);

  if( hgedp->log_uewkt < 0.0 )
    {
      sprintf(kvp,"l=%lf",hgedp->log_uewkt);
      sprintf(target," %s",kvp);
      target += strlen(kvp) + 1;
    }
  if( hgedp->rulenumber >= 0 )
    {
      sprintf(kvp,"rn=%d",hgedp->rulenumber);
      sprintf(target," %s",kvp);
      target += strlen(kvp) +1;
    }
  return target;
}

void Chgraph::removeWordseps()
{
  removeSymbols(wordseps);

}

void Chgraph::removeSymbols(char** symlist)
{
  Cnode** ndptrptr;
  Clistel<Cnode*> *ndlistel;
  Chgrnode *hgrndptr;
  Cedge** edppv,**edppn,*edp;
  int i,k;

  for( k=0,ndptrptr = nodes.skipThru(init,&ndlistel) ; 
       k < nodes.getAnzel(); )
    {
      if( (hgrndptr = (Chgrnode*)*ndptrptr) == NULL )
	{
	  warning(__FILE__,__LINE__,"defective Hypgraph");
	  delNode(hgrndptr,NULL,NULL);
	  continue;
	}
      
      for( i = 0 ; symlist[i] != NULL ; i++ )
	{
	  if( !strcmp(hgrndptr->symbol,symlist[i] ))
	    {
	      break;
	    }
	}

      if( symlist[i] != NULL) 
	{
	  int i,j,ns,np;
	  Cnode** succnds;
	  Cnode** prednds;

	  delNode( hgrndptr,&succnds,&ns,&prednds,&np);
	  for( i=0 ; i<np ; i++ )
	    {
	      for( j=0 ; j<ns ; j++ )
		{
		  addEdge(NULL,prednds[i],succnds[j]);
		}
	    }
	  delete [] succnds;
	  delete [] prednds;
	}
      else
	{
	  ndptrptr = nodes.skipThru(next,&ndlistel);
	  k++;
	}
    }
}


void Chgraph::getAddinfo(Cnode* ndptr,char* target)
{
}

void Chgraph::getAddinfo(Cedge* edptr,char* target)
{
}


void Chgraph::jumpWordseps(double log_jumpwk)
{
  Cnode** ndptrptr;
  Clistel<Cnode*> *ndlistel;
  Cedge** edppv,**edppn,*edp;
  Clistel<Cedge*> *edlistelv,*edlisteln;
  Chgrnode *hgrndptr;
  int k;
  double addprob;

  for( ndptrptr = nodes.skipThru(init,&ndlistel) ; 
       ndptrptr != NULL ;
       ndptrptr = nodes.skipThru(next,&ndlistel) )
    {
      if( (hgrndptr = (Chgrnode*)*ndptrptr) == NULL )
	{
	  warning(__FILE__,__LINE__,"defective Hypgraph");
	  delNode(hgrndptr,NULL,NULL);
	  continue;
	}
      
      if(strpbrk(hgrndptr->symbol,"#&") != NULL) 
	{
	  for( edppv = hgrndptr->predecs.skipThru(init,&edlistelv);
	       edppv != NULL ;
	       edppv = hgrndptr->predecs.skipThru(next,&edlistelv) )
	    {
	      for( edppn = hgrndptr->succs.skipThru(init,&edlisteln) ;
		   edppn != NULL ;
		   edppn = hgrndptr->succs.skipThru(next,&edlisteln))
		{
		  addprob=-1.0;
		  if( edp = isIn((*edppv)->startnode,(*edppn)->endnode) )
		    {
		      addprob = edp->log_uewkt;
		    }
		  else
		    {
		      edp=addEdge(NULL,(*edppv)->startnode,(*edppn)->endnode);
		    }
		  edp->log_uewkt = (*edppv)->log_uewkt + (*edppn)->log_uewkt +
		    log_jumpwk;
		  if( addprob > 0 )
		    {
		      edp->log_uewkt = log( exp(edp->log_uewkt) + addprob );
		    }
		  //this is a problem: jumpWordseps may introduce 
		  //double-ruled edges!
		  ((Chgredge*)edp)->rulenumber =
		    ((Chgredge*)*edppv)->rulenumber >= 0 ? 
		    ((Chgredge*)*edppv)->rulenumber : 
		    ((Chgredge*)*edppn)->rulenumber;
		}
	      (*edppv)->log_uewkt += log( 1 - exp(log_jumpwk));
	    }
	}
    }
}

double Chgraph::scoreEdges()
{
  int i,maxrank;
  Chgrnode* hgrnode;
  Cedge** edptrptr;
  Cnode** ndlist;
  int ndanz;
  double pathes;
  double sumwk;

  
  maxrank = getRanks();
  ndanz = nodes.compact(&ndlist);
  qsort((char*)ndlist,ndanz,sizeof(Cnode*),compranks);
  
  //Anzahl der Wege zu jedem Knoten abzaehlen
  for( i=0, pathes=0; i<ndanz ; i++ )
    {
      hgrnode = (Chgrnode*)ndlist[i];
      if( hgrnode->rank == 0 )
	{
	  hgrnode->numpath=1;
	}
      else
	{
	  for( edptrptr=hgrnode->predecs.skipThru(init) ; 
	       edptrptr!=NULL ;
	       edptrptr=hgrnode->predecs.skipThru(next) )
	    {
	      hgrnode->numpath += 
		((Chgrnode*)((*edptrptr)->startnode))->numpath;
	    }
	}
      if( hgrnode->succs.getAnzel() == 0 )
	{
	  pathes += hgrnode->numpath;
	}
    }

  //ruckwaerts die Wahrscheinlichkeiten berechnen
  for( i=ndanz-1 ; i>=0 ; i-- )
    {
      hgrnode = (Chgrnode*)ndlist[i];

      //wk des knotens
      if( hgrnode->succs.getAnzel() == 0 )
	{
	  hgrnode->log_wkt = log(hgrnode->numpath) - log(pathes );
	  continue;
	}

      for(sumwk=0.0 , edptrptr=hgrnode->succs.skipThru(init) ; 
	   edptrptr!=NULL ;
	   edptrptr=hgrnode->succs.skipThru(next) )
	{
	  sumwk +=
	    ( exp( ((Chgrnode*)((*edptrptr)->endnode))->log_wkt ) *
	      hgrnode->numpath) /
	    ((Chgrnode*)((*edptrptr)->endnode))->numpath;
	}
      hgrnode->log_wkt = log( sumwk );
      //uebergangswkt
      for( edptrptr=hgrnode->succs.skipThru(init) ; 
	   edptrptr!=NULL ;
	   edptrptr=hgrnode->succs.skipThru(next) )
	{
	  ((Chgredge*)(*edptrptr))->log_uewkt = 
		       ((Chgrnode*)((*edptrptr)->endnode))->log_wkt  +
		       log( hgrnode->numpath ) -
		       hgrnode->log_wkt -
		       log( ((Chgrnode*)((*edptrptr)->endnode))->numpath );
	}
    }
  delete [] ndlist;
  return pathes;
}

void Chgraph::clear()
{
  free(filename);
  char **cpp;
  for( cpp=ortho.skipThru(init) ; cpp != NULL ; cpp=ortho.skipThru(next) )
    {
      free(*cpp);
    }
  ortho.clear();
  
  Cgraph::clear();
}



Chgraph::~Chgraph()
{
  int i;
  
  clear();
  
  for( i=0 ; i<anzinv ; i++ )
    {
      free(inventar[i]);
    }
    
  delete [] inventar;
}

