//****************************************************************************
//
// CCfile: Cfindwn.cc
//
// Autor: A. Kipp
// erstellt: Tue Apr 8 08:28:21 MET DST 1997
// veraendert:
//
// Enthaelt:
//***************************************************************************
#include "Cfindwn.h"
#include "CCexceptions.h"

struct stackelem
{
  stackelem() { hnp=NULL;inx=-1;rulenr=-1;};
  Chgrnode* hnp;
  int inx;
  int rulenr;
};

//***************************************************************************
// Implementierung der Klasse: Cfindwn
// Autor: A. Kipp
// erstellt: Tue Apr 8 08:28:21 MET DST 1997 
// veraendert:
//***************************************************************************
int Cfindwn::find(Chgraph* hgr,segment_rec** srl,int anzl)
{
  //hgr und segio muessen sich auf das gleiche file beziehen

  stackelem stack[STACKSIZE];
  int stackcount = 0;
  Chgrnode* hgrndptr,*fn;
  Cnode** ndpp;
  Cedge** edpp;
  segment_rec** spp;
  int index;
  int* wn = new int[anzl];
  int* rn = new int[anzl];
  int done;

  //find startsym
  for( ndpp = hgr->nodes.skipThru(init);
       ndpp != NULL;
       ndpp = hgr->nodes.skipThru(next) )
    {
      hgrndptr = (Chgrnode*)*ndpp;
      if( !strcmp(hgrndptr->symbol,"<") )
	{
	  stack[stackcount].hnp = hgrndptr;
	  stack[stackcount++].inx=0;
	}
    }

  if( stackcount == 0 )
    {
      return -1;
    }

  
  
  //perform depht-first search
  while( --stackcount >=0 )
    {
      //take element from stack
      index = stack[stackcount].inx + 1;
      fn = stack[stackcount].hnp;
      //write wn
      wn[index-1] = fn->wordnum;
      rn[index-1] = stack[stackcount].rulenr;
      if( index >= anzl )
	{
	  //we're done
	  break;
	}
      done = 0;
      for( edpp = fn->succs.skipThru(init);
	   edpp != NULL;
	   edpp = fn->succs.skipThru(next) )
	{
	  hgrndptr = (Chgrnode*)(*edpp)->endnode;
	  if( !strcmp(hgrndptr->symbol,srl[index]->symbol) || 
	      (( !strcmp(hgrndptr->symbol,"#") ||
                 !strcmp(hgrndptr->symbol,">") ) && 
	       !strcmp(srl[index]->symbol,"<p:>") ) )
	    {
	      stack[stackcount].hnp = hgrndptr;
	      stack[stackcount].rulenr = ((Chgredge*)*edpp)->rulenumber;
	      stack[stackcount++].inx = index;
	      done++;
	      if( verbose )
		{
		  printf("trace[%d]: %s index=%d %d->%d\n",stackcount,
		     srl[index]->symbol,
		     index,fn->nodenr,
			 hgrndptr->nodenr);
		}
	    }
	 
	  if( stackcount > STACKSIZE )
	    {
	      //strange graph!
	      failure(__FILE__,__LINE__,"stack-overflow");
	    }
	}
      if( verbose && done == 0 )
	{
	  //was a dead end
	  printf("     %d-X ..%s\n",fn->nodenr,srl[index]->symbol);
	}
    }

  if( stackcount < 0 )
    {
      //oops, no way through
      printf("couldnt find %s\n",srl[index]->symbol);
      return -2;
    }

  int i;
  char line[200];
  char rnstr[20];
  for( i=0 ; i< anzl ; i++ )
    {
      if( rn[i] >= 0 )
	{
	  sprintf(rnstr," rn=%d",rn[i] );
	}
      else
	{
	  rnstr[0] = '\0';
	}
      sprintf(line,"%s wn=%d%s",
	      srl[i]->addinfo==NULL ? "" : srl[i]->addinfo,
	      wn[i],rnstr);
      if( srl[i]->addinfo != NULL )
	{
	  delete [] srl[i]->addinfo;
	}
      srl[i]->addinfo = strdup(line);
    }

  delete [] wn;
  return index;
}
	      
      
