%{
#include <stdlib.h>
#include "Cgraph.h"

extern Cgraph* pgraph;
char linebuf[100];
int bp;

void initbuffer();

int grapherror(char* s) { fprintf(stderr,"%s\n",s); };
extern "C"{
int graphlex(void);
}
%}
%union{
  int intval;
  double doubleval;
  char charval;
  }
%token <intval> INTNUM
%token <charval> CHAR
%token  WHITE
%token  NODELISTMARK
%token  EDGELISTMARK
%token  FILENAMEMARK
%token  L_CB
%token  R_CB
%token  NEWLINE
%token  EQ
%start file
%%
/* grammar */
file		: ignore filename ignore graph ignore
		;
		
filename	: FILENAMEMARK ignore EQ ignore identifier
		;
graph		: NODELISTMARK 
                    { 
                    pgraph->clear();
                    } 
                  ignore 
                  L_CB 
                  nodelist 
                  R_CB ignore 
                  EDGELISTMARK 
                  ignore 
                  L_CB 
                  edgelist 
                  R_CB

		| error { yyerror("illegal graph"); }
		;

nodelist	: 
		| nodelist 
		  nodeitem
		
		| error { yyerror("illegal nodelist"); }
		;

nodeitem	: NEWLINE
		
		| INTNUM 
		    {
		    initbuffer(); 
		    }
		  addinfo
		  NEWLINE 
		    {
		    Cnode* ndptr = pgraph->newNode();
		    ndptr->nodenr =  $1 ;
		    ndptr->putInfo(linebuf);
		    pgraph->addNode(ndptr);
		    }
		                   
		| error { yyerror("illegal nodeitem"); }
		;
edgelist	:
		| edgelist 
		  edgeitem
		  
		| error { yyerror("illegal edgelist"); }
edgeitem	: NEWLINE
		
		| INTNUM 
		  WHITE 
		  INTNUM 
		    { 
		    initbuffer();
		    }
		  addinfo 
		  NEWLINE
		    {
		    Cedge* edptr = pgraph->addEdge(NULL,
		                   pgraph->getNodeNr( $1 ),
		                   pgraph->getNodeNr( $3 ) );
		    edptr->putInfo(linebuf);
		    }
		    
		| error { yyerror("illegal edgeitem"); }
		;
addinfo		: 
		| addinfo CHAR { sprintf(linebuf + bp++,"%c",$2); }
		| addinfo WHITE { sprintf(linebuf + bp++," "); }
		| addinfo INTNUM { sprintf(linebuf + bp,"%d",$2);
		  for(; linebuf[bp] != '\0' ; bp++) ; }
		| error { yyerror("illegal addinfo"); }
		;
identifier	: CHAR
		| INTNUM
		| identifier INTNUM
		| identifier CHAR
ignore		:
		| ignore NEWLINE
		| ignore WHITE
		;
%%
void initbuffer()
  {
  linebuf[0]='\0';
  bp=0;
  }
  
