//***************************************************************************
//
// CCFile: iotoolbox.h
//
// Autor: A.Kipp
// erstellt: veraendert:
//
// Enthaelt: routinen zum einlesen und ausgeben von datenfiles
//***************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include "iotoolbox.h"
extern "C" {
#include "/home/ipkclib/ipkclib.h"
}

#define SPACES " /n/t"

long read_phondat_speechfile(char* name, short** sbufptr)
  {
  FILE* fp;
  long nofbytes,merker;
  Phon_header_2 *header;
  char *orth,*kan;
  

  if( (fp = fopen(name,"rb")) == NULL )
    {
    return -1;
    }

  // Phondat-header
  if( (header = read_header_sun(fp,&orth,&kan)) == NULL )
    {
    return -1;
    }
    
  // laenge feststellen
  merker = ftell(fp);
  fseek(fp,0L,SEEK_END);
  nofbytes =ftell(fp) - merker;
  fseek(fp,merker,SEEK_SET);

  // buffer alloziieren
  (char*)(*sbufptr) = new char[nofbytes];
  if( *sbufptr == 0 )
    {
    fprintf(stderr,"Out of Mem %s line %d\n",__FILE__,__LINE__);
    return -2;
    }

  // einlesen
  if( fread((char*)(*sbufptr),sizeof(char),nofbytes,fp) != nofbytes )
    {
    fprintf(stderr,"Read error\n");
    return -3;
    }

  // swappen
  register char* cp, temp;
  int n;
    
  cp= (char*)(*sbufptr);

  for(n=0 ; n< nofbytes/2 ; n++) // unbedingt noch als inline-fkt
    {
    temp=cp[0];
    cp[0]=cp[1];
    cp[1]=temp;
    cp+=2;
    }

  fclose(fp);
  // platz freigeben
  free( (char*)header );
  free( (char*)orth);
  free( (char*)kan);
  return nofbytes/2;
  }

FILE* open_phondat_speechfile(char* name)
  {
  FILE* fp;
  Phon_header_2 *header;
  char *orth,*kan;
  

  if( (fp = fopen(name,"rb")) == NULL )
    {
    return NULL;
    }

  // Phondat-header
  if( (header = read_header_sun(fp,&orth,&kan)) == NULL )
    {
    return NULL;
    }

  free( (char*)orth);
  free( (char*)kan);
   
  return fp;
  }

int read_phondat_label_file(char* name,struct phondatlabelinf* plinf)
  {
  FILE* fp;
  labrec *lrp = new labrec;
  char* buf,*cp1,*cp2;
  
  if( (fp=fopen(name,"r")) == NULL )
    {
    return (-1) * __LINE__;
    }
    
  //lese file ein
  fseek(fp,0,2);
  long len = ftell(fp);
  rewind(fp);
  buf = new char[len];
  
  if( fread(buf,1,len,fp) != len )
    {
    return -1 * __LINE__;
    }
   
  //filename
  if( (cp1 = strchr(buf,'\n')) == NULL )
    {
    return -1 * __LINE__;
    }
  
  plinf->filename = new char[++cp1-buf];
  sscanf(buf,"%s",plinf->filename);
  
  //ortho
  if( (cp2 = strstr(cp1,"oend")) == NULL )
    {
    cp2=cp1;
    } 
  else
    {
    plinf->ortho = new char[cp2-cp1+1];
    memcpy(plinf->ortho,cp1,cp2-cp1);
    cp1 = cp2 + strlen("oend");
    cp1 += strspn(cp1,SPACES);
    }
  
  //kano
  if( (cp2 = strstr(cp1,"kend")) == NULL )
    {
    cp2 = cp1;
    } 
  else
    {
    plinf->kano = new char[cp2-cp1+1];
    memcpy(plinf->kano,cp1,cp2-cp1);
    cp1 = cp2 + strlen("kend");
    cp1 += strspn(cp1,SPACES);
    }
    
  //kano
  if( (cp2 = strstr(cp1,"hend")) == NULL )
    {
    cp2 = cp1;
    } 
  else
    {
    plinf->h = new char[cp2-cp1+1];
    memcpy(plinf->h,cp1,cp2-cp1);
    cp1 = cp2 + strlen("hend");
    cp1 += strspn(cp1,SPACES);
    }
  
  do
    {
    cp1++;
    if( sscanf(cp1,"%d %s %lf",&lrp->start,lrp->lab,&lrp->score) > 2 )
      {
      plinf->lablist.addEl(&lrp);
      lrp = new labrec;
      }
    }while( (cp1 = strchr(cp1,'\n')) != NULL);
    
  delete [] buf;
  delete lrp;
  fclose(fp);
  return 1;
  }
  
void swap_short(short* s,int anz)
  {
  // swappen
  register char* cp, temp;
  register int n;
    
  cp= (char*)s;

  for(n=0 ; n< anz ; n++) // unbedingt noch als inline-fkt
    {
    temp=cp[0];
    cp[0]=cp[1];
    cp[1]=temp;
    cp+=2;
    }
  }

int write_phondat_label_file(char* name,struct phondatlabelinf* plinf)
  {
  FILE* fp;
  labrec** lrpp;
  
  if( (fp=fopen(name,"w")) == NULL )
    {
    return (-1) * __LINE__;
    }
    
  fprintf(fp,"%s\n",plinf->filename);
  fprintf(fp,"%s",plinf->ortho);
  fprintf(fp,"oend\n");
  fprintf(fp,"%s",plinf->kano);
  fprintf(fp,"kend");
  fprintf(fp,"%s",plinf->h);
  fprintf(fp,"hend\n");
  
  for(lrpp=plinf->lablist.skipThru(init) ; lrpp!=NULL ; 
  lrpp = plinf->lablist.skipThru(next))
    {
    fprintf(fp,"\t %ld %s %lf\n",(*lrpp)->start,(*lrpp)->lab,(*lrpp)->score);
    }
    
  fclose(fp);
  return 1;
  }
  
  
