//****************************************************************************
//
// CCfile: Cpartitur_io.cc
//
// Autor: A. Kipp
// erstellt: Thu Nov 16 12:34:09 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "Cpartitur_io.h"
#include "CCexceptions.h"

#define SAMENDMARK "ELF:"

int frwkan(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp);
int frwsam(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp);
int frwtrl(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp);
int frwwrd(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp);

RecDesc Cpartitur_io::descs[] = 
  {
    {"KAN:","1KAN:%1$s","KAN: %d %s","KAN: %d %s\n",frwkan},
    {"TRL:","1TRL:%1$s",NULL,"TRL: %s",frwtrl},
    {"WRD:","1WRD:%1$s","WRD: %d %d %s %d","WRD: %d %d %s %d\n",frwwrd},
    {"SAM:","1SAM:%1$s","SAM: %d %d %s %s","SAM: %d %d %s %s\n",frwsam},
    {NULL,NULL,NULL}
  };


//***************************************************************************
// Implementierung der Klasse: Cpartitur_io
// Autor: A. Kipp
// erstellt: Thu Nov 16 12:34:09 1995 
// veraendert:
//***************************************************************************
Cpartitur_io::Cpartitur_io()
  {
  int id;
  //Labelfileheader
  recLabelheaderdesc();
  for( id=0 ; descs[id].key != NULL ; id++ );
  recheads = new RecHead[id];
  for( id=0 ; descs[id].key != NULL ; id++ )
    {
    recheads[id].id = id; //alles klar?
    specList(descs[id].testmask,descs[id].fptr,this,0);
    }
  nrecs = id;
  setEndMark(SAMENDMARK);  
  }

void Cpartitur_io::recLabelheaderdesc()
  {
  specString("LHD:",&headernameandversion,1);
  specString("REP:",&recordingsite,1);
  specCvar("SNB: %d",&bytespersample,1);
  specCvar("SBF: %s",&byteorder,1);
  specCvar("NCH: %d",&numchan,1);
  specCvar("SSB: %d",&bitspersample,1);
  specCvar("SPN: %s",&speaker,1);
  }
    
int frwkan(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp)
  {
  KanRec* kr;
  PartiturRec** prpp;
  RecHead* prhead;
  RecDesc* prdesc;
  char wrd[80];
  static int id=-1;
  
  if( id < 0 )
    {
    //wir muessen rausfinden wo die daten angehaengt werden sollen
    //das aendert sich nicht waehrend der Laufzeit, auch nicht fuer
    //andere instanzen!
    for( id=0 ; 
    ((RecDesc*)((Cpartitur_io*)addr)->descs)[id].fptr != frwkan ;
     id++ );
    }
  
  prhead = (RecHead*)((Cpartitur_io*)addr)->recheads + id;
  prdesc = (RecDesc*)((Cpartitur_io*)addr)->descs + id;
  
  switch(cntl)
    {
    case readf:
    kr = new KanRec;
    if( sscanf(line,prdesc->scanmask,&(kr->wordnr),wrd) != 2 )
      {
      return -1;
      delete kr;
      }
    kr->word=strdup(wrd);
    prhead->recs.addEl((PartiturRec**)&kr);
    break;
    
    case writef:
    for( prpp=prhead->recs.skipThru(init) ; prpp != NULL ; 
         prpp=prhead->recs.skipThru(next) )
      {
      kr = (KanRec*)(*prpp);
      fprintf(fp,prdesc->printmask,kr->wordnr,kr->word);
      }
    break;
    }
  }
  
int frwsam(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp)
  {
  SamRec *sr;
  PartiturRec** prpp;
  RecHead* prhead;
  RecDesc* prdesc;
  char label[50];
  char wrefs[20];
  static int id=-1;
  char* cp,*ptr;
  Cverklist<int> il;
  int i;

  if( id < 0 )
    {
    //wir muessen rausfinden wo die daten angehaengt werden sollen
    //das aendert sich nicht waehrend der Laufzeit, auch nicht fuer
    //andere instanzen!
    for( id=0 ; 
    ((RecDesc*)((Cpartitur_io*)addr)->descs)[id].fptr != frwsam ;
     id++ );
    }
  
  prhead = (RecHead*)((Cpartitur_io*)addr)->recheads + id;
  prdesc = (RecDesc*)((Cpartitur_io*)addr)->descs + id;
  
  switch(cntl)
    {
    case readf:
    sr = new SamRec;
    if( sscanf(line,prdesc->scanmask,&(sr->start),&(sr->duration),label,
        wrefs) != 4 )
      {
      return -1;
      delete sr;
      }
    sr->symbol=strdup(label);
    for( cp=strtok(wrefs,",") ; cp!=NULL; cp=strtok(NULL,",") )
      {
      i=(int)strtol(cp,&ptr,10);
      i = cp != ptr ? i : -1;
      il.addEl(&i);
      }
    sr->nwrefs = il.compact(&(sr->wrefs));
    
    prhead->recs.addEl((PartiturRec**)&sr);
    break;

    case writef:
    for( prpp=prhead->recs.skipThru(init) ; prpp != NULL ; 
         prpp=prhead->recs.skipThru(next) )
      {
      sr = (SamRec*)(*prpp);
      for( i=0,cp=wrefs ; i<sr->nwrefs ; i++ )
        {
        sprintf(cp,"%d,",sr->wrefs[i]);
        cp = strchr(cp,',');
        cp++;
        }
      *(cp -1) = '\0';
      fprintf(fp,prdesc->printmask,sr->start,sr->duration,sr->symbol,
      wrefs);
      }
    break;
    
    }
  }
    
int frwtrl(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp)
  {
  TrlRec* tr;
  PartiturRec** prpp;
  RecHead* prhead;
  RecDesc* prdesc;
  static int id=-1;
  char trlline[100];
  char* cp;
  
  if( id < 0 )
    {
    //wir muessen rausfinden wo die daten angehaengt werden sollen
    //das aendert sich nicht waehrend der Laufzeit, auch nicht fuer
    //andere instanzen!
    for( id=0 ; 
    ((RecDesc*)((Cpartitur_io*)addr)->descs)[id].fptr != frwtrl ;
     id++ );
    }
  
  prhead = (RecHead*)((Cpartitur_io*)addr)->recheads + id;
  prdesc = (RecDesc*)((Cpartitur_io*)addr)->descs + id;

  switch(cntl)
    {
    case readf:
    tr = new TrlRec;
    cp = line + strlen(prdesc->key);
    cp += strspn(cp," \t");
    tr->line = strdup(cp);
    prhead->recs.addEl((PartiturRec**)&tr);
    break;
    
    case writef:
    for( prpp=prhead->recs.skipThru(init) ; prpp != NULL ; 
         prpp=prhead->recs.skipThru(next) )
      {
      tr = (TrlRec*)(*prpp);
      fprintf(fp,prdesc->printmask,tr->line);
      }
    break;
    }
    
  }
  
int frwwrd(frw_cntl cntl,char* line,Cheader_io* addr,FILE* fp)
  {
  WrdRec* wr;
  PartiturRec** prpp;
  RecHead* prhead;
  RecDesc* prdesc;
  char wrd[80];
  static int id=-1;
  
  if( id < 0 )
    {
    //wir muessen rausfinden wo die daten angehaengt werden sollen
    //das aendert sich nicht waehrend der Laufzeit, auch nicht fuer
    //andere instanzen!
    for( id=0 ; 
    ((RecDesc*)((Cpartitur_io*)addr)->descs)[id].fptr != frwwrd ;
     id++ );
    }
  
  prhead = (RecHead*)((Cpartitur_io*)addr)->recheads + id;
  prdesc = (RecDesc*)((Cpartitur_io*)addr)->descs + id;
  
  switch(cntl)
    {
    case readf:
    wr = new WrdRec;
    if( sscanf(line,prdesc->scanmask,&(wr->start),&(wr->duration),wrd,
    &(wr->wref) ) != 4 )
      {
      return -1;
      delete wr;
      }
    wr->word=strdup(wrd);
    prhead->recs.addEl((PartiturRec**)&wr);
    break;
    
    case writef:
    for( prpp=prhead->recs.skipThru(init) ; prpp != NULL ; 
         prpp=prhead->recs.skipThru(next) )
      {
      wr = (WrdRec*)(*prpp);
      fprintf(fp,prdesc->printmask,wr->start,wr->duration,wr->word,wr->wref);
      }
    break;
    }
  }
