# Usage: python3 convert-comments.py {outfile_path} {brackets} {left_bracket} {whitespace_replacement}

import sys, re

def convert_comment(match):
    """
    Take an `re.match` object and return it as a string with all
    whitespace replaced by `whitespace_replacement`.
    """
    comment = match.group(0)
    comment = re.sub(r'\s+', whitespace_replacement, comment)
    return '<' + comment + '>'

if __name__ == '__main__':
    outfile_path, brackets, left_bracket, whitespace_replacement = sys.argv[1:]
    
    with open(outfile_path, mode = 'r', encoding = 'utf-8', newline = '\n') as outfile:
        content = outfile.read()
    
    ### Convert bilateral brackets
    for i in range(0, len(brackets), 2):
        left, right = brackets[i:i+2]
        left = re.escape(left)
        right = re.escape(right)
        comment_match = re.compile(left + '.*?' + right, flags = re.DOTALL)
        content = comment_match.sub(convert_comment, content)
    ###
    
    ### Convert left brackets
    for bracket in left_bracket:
        bracket = re.escape(bracket)
        comment_match = re.compile(bracket + '.*?$', flags = re.MULTILINE)
        content = comment_match.sub(convert_comment, content)
    ###
    
    with open(outfile_path, mode = 'w', encoding = 'utf-8', newline = '\n') as outfile:
        outfile.write(content)
