# textEnhance
This is a program to enhance text files and prepare them for processing by the BAS WebServices.

## Usage
```
textEnhance [-v/--verbose] [--brackets BRACKETS]
            [--left-bracket LEFT_BRACKET]
            [--replace-whitespace-char WHITESPACE_REPLACEMENT]
            [--version] [--help]
            INPUT -o/--outfile OUTFILE
```
Run `textEnhance --help` for a description of each argument.

## What it does
When you call `textEnhance` on a file, it will copy it to the specified output
and make sure that it meets the following criteria:
- Encoded with UTF-8 (no BOM)
- Line terminators are LF (Unix style)
- Trailing newline at the end of the file

It will also convert any comments to "BAS-compatible" comments. These are comments
which are enclosed in angle brackets ('<>') and contain no whitespace. So if your
input has, for example, comments enclosed in square brackets as well as comments
starting with a hash:
```
SPK1: And I said, "what's up with that?"
[Speaker 2 has a perplexed look on his face.
Speaker 3 enters.]
SPK3: What are we talking about?  # rising inflection
```
You would have to specify these symbols with the parameters `--brackets '[]'`
and `--left-bracket '#'`. They would then be converted like so:
```
SPK1: And I said, "what's up with that?"
<[Speaker_2_has_a_perplexed_look_on_his_face._Speaker_3_enters.]>
SPK3: What are we talking about?  <#_rising_inflection>
```
Be aware that enclosed comments only can span mutliple lines.

## Requirements
- bash 4.4
- python 3.6.9
- file 5.32
- iconv 2.27
- dos2unix 7.3.4
- grep 3.1
- mktemp 8.28

Note: these are the versions that textEnhance has been confirmed to work with.
However, higher versions should work as well, and lower versions in most cases
too. The only certain restriction is on filenames with bash versions < 4.4 (see
section "Remarks")

## Remarks
The program passes the arguments it receives to the helper script `parse-arguments.py`.
Passing command line arguments which contain characters that need to be escaped
before being passed on (such as spaces or quotes) require the `@Q` operator, which
was introduced with bash version 4.4. If you have a lower bash version, you can
simply remove this operator, but bear in mind that you cannot have any command
line arguments with special characters in that case.  
Note also that the program does not accept input file names with any whitespace,
non-ASCII characters or POSIX Extended Regular Expression metacharacters (except
dots) in them, so it's best to use sensible file names anyway. The `@Q` operator
is still there because the enforcement of said rule is done by the helper script;
in order to provide meaningful error messages, the arguments need to be passed in
an escaped manner.
