//****************************************************************************
//
// CCfile: Cmatrix.cc
//
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//
// Enthaelt:
//****************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Cmatrix.h"


//***************************************************************************
// Implementierung der Klasse: Cmatrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

Cmatrix::Cmatrix(Cvektor* p_row, int nr)
  {
  int i;

  num_of_cols=p_row[0].dim();
  num_of_rows=nr;
  
  data = new double[num_of_cols*num_of_rows];
  pp_row = new Cvektor*[num_of_rows];
  if( pp_row == 0 || data == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
    
  for( i=0 ; i<nr ; i++ )
    {
    memcpy(data+i*num_of_cols,p_row[i].data,num_of_cols*sizeof(double));
    pp_row[i]=new Cvektor(data+i*num_of_cols,num_of_cols);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    }

  mem=0;
  }

Cmatrix::Cmatrix(double* data,int nr, int nc)
  {
  int i;

  pp_row = new Cvektor*[nr];
  if( pp_row == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  num_of_cols=nc;
  num_of_rows=nr;

  for( i=0 ; i<nr ; i++ )
    {
    pp_row[i]=new Cvektor(data + i*nc, nc);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    }
  mem=1;
  }

Cmatrix::Cmatrix(int nr, int nc)
  {
  int i;

  num_of_cols=nc;
  num_of_rows=nr;

  data = new double[num_of_cols*num_of_rows];
  pp_row = new Cvektor*[num_of_rows];
  if( pp_row == 0 || data == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
    
  for( i=0 ; i<nr ; i++ )
    {
    pp_row[i]=new Cvektor(data+i*num_of_cols,num_of_cols);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    }
  mem=1;
  }

// copy-Konstruktor
Cmatrix::Cmatrix(Cmatrix& mat)
  {
  int i,j;

  num_of_cols=mat.num_of_cols;
  num_of_rows=mat.num_of_cols;

  data = new double[num_of_cols*num_of_rows];
  pp_row = new Cvektor*[num_of_rows];
  if( pp_row == 0 || data == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
    
  for( i=0 ; i<num_of_rows ; i++ )
    {
    pp_row[i]=new Cvektor(data+i*num_of_cols,num_of_cols);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    }
  mem=1; 

  // werte explizit setzen
  for( i=0 ; i<num_of_rows ; i++ )
    {
    for( j=0 ; j<num_of_cols ; j++ )
      {
      setVal(i,j,mat.getVal(i,j));
      }
    }

  }
  
  
void Cmatrix::clearMat()
  {
  memset(data,0,num_of_cols*num_of_rows*sizeof(double));
  }

void Cmatrix::printMat()
  {
  int r,c;

  for( r=0 ; r<num_of_rows ; r++)
    {
    for( c=0 ; c<num_of_cols ; c++ )
      {
      printf("(%d,%d) = %lf\n",r,c,getVal(r,c));
      }
    }
  }

Cvektor Cmatrix::operator*(Cvektor& vek)
  {
  int i,j;
  Cvektor erg(num_of_rows);
  
  erg.clearVek();
  
  if( vek.dim() != num_of_cols )
    {
    fprintf(stderr,"Vektor-Matrix Dimension not equal!\n");
    exit(1);
    }
    
  for( i=0 ; i< num_of_rows ; i++ )
    {
    for( j=0 ; j< num_of_cols ; j++ )
      {
      erg.incVal(i,vek.getVal(j)*getVal(i,j));
      }
    }
  return erg;
  }
    
Cmatrix Cmatrix::operator*(Cmatrix& mat)
  {
  int i,j,k;
  Cmatrix erg(num_of_rows,mat.num_of_cols);
  
  erg.clearMat();
  
  if( mat.num_of_rows != num_of_cols )
    {
    fprintf(stderr,"Vektor-Matrix Dimension not equal!\n");
    exit(1);
    }
    
  for( i=0 ; i< num_of_rows ; i++ )
    {
    for( j=0 ; j< mat.num_of_cols ; j++ )
      {
      for( k=0 ; k<num_of_cols ; k++ )
        {
        erg.incVal(i,j,getVal(i,k)*mat.getVal(k,j));
        }
      }
    }
  return erg;
  }
    

Cmatrix::~Cmatrix()
  {

  if( mem )
    {
    delete [] data;
    }

  delete [] pp_row;
  }
