/*	header fuer subroutinen der library ipkclib

	F. Schiel	15.11.90/15.12.92				*/

#ifndef _IPKCLIB_H
#define _IPKCLIB_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef FILE
# include <stdio.h>
#endif 

/* Praeprozessor-Konstanten, die von mehreren Modulen der Library verwendet 
   werden mit Angabe der Module in alphabetischer Reihenfolge		*/

/* LABEL								*/
# define LABANZ		100	/* max. anzahl labeln pro satz	*/

/* LINUXAUDIO 								*/
#ifndef LINUXAUDIO
#define DSP_TYPE_LINEAR_16 1    /* Uebergebene Daten sind Linear 16 Bit	*/
#define DSP_TYPE_ALAW_8 2       /* Uebergebene Daten sind ALaw 8 Bit */
#define DSP_TYPE_ULAW_8 3       /* Uebergebene Daten sind ULaw 8 Bit */
#define DSP_OPEN_FAILED 100     /* Audio Device konnte nicht geoeffnet werden */
#define DSP_UNKNOWN_TYPE 101    /* Uebergebener Datentyp unbekannt */
#define DSP_OUT_OF_MEM 102      /* Kein Speicherplatz fuer Zwischenpuffer */
#define DSP_ILLEGAL_BUFSIZE 103 /* Puffer der Karte nicht zw. 4096 und 65536 */
#define DSP_NO_ERROR 0          /* Kein Fehler */
#define LINUXAUDIO
#endif

/*######################################################################*/

/* Type-Definitionen die von mehr als einem Modul verwendet werden, bzw. in 
   Aufrufen von Funktionen der Library auftauchen in alphabetischer 
   Reihenfolge mit Angabe der Herkunft					*/

/* Label LABEL								*/
	typedef struct
		{	
			int 	anz;
			long	beginn[LABANZ];
			long	end[LABANZ];
			char	*silbos[LABANZ];
			char	*ipsk[LABANZ];
		}	Label;
/* matrix MATRIX							*/
    typedef struct  {
	long z ; /*Zeilenzahl*/
	long s ; /*Spaltenzahl*/
	double ** m ; /*Matrix*/
	} matrix ;
/* Stcb CLUSTER_UTI							*/
	typedef struct
		{	
			float	*cb;		/* codebuch 		*/
			float	interset;	
			float	varinter;
			float	intraset;
			float	varintra;
			char	abstand[20];	/* art des abstandsmass	*/
			char	codetyp[20];	/* merkmalstyp		*/
			int	dim;
			int	n;		/* anzahl der symbole	*/
			float	*det;		/* determinanten	*/
			matrix	**invkov;	/* inv. kovarianzmatrizen*/
			long	detnorm;	/* norm.fakt f. determ.	
						   und inv. kovarianzen	*/
			float	**invdia;	/* inv. hauptdiagonalen	*/
		}	Stcb;
/* Stclus CLUSTER_UTI							*/
	typedef	struct 	
		{		/* struktur fuer verteilung der 	*/
		int	n;	/* datenvektoren auf prototypen		*/
		int	*anz;
		float	***part;
		}	Stclus;

/* Phon_header_2 HEADER */
typedef struct {
                long    not_used1[5],
                        nspbk,          /* # of data blocks (512 bytes) */
                        anz_header,     /* # of header blocks (512 bytes)
                                           allways odd !                */
                        not_used2[5];
                char    sprk[2];        /* speaker id                   */
                short   swdh;           /* session repetition           */
                long    ifld1[3],       /* ILS                          */
                        not_used3[6];
                char    kenn1[2];       /* ILS text characters 1 - 8    */
                short   not_used4;
                char    kenn2[2];
                short   not_used5;
                char    kenn3[2];
                short   not_used6;
                char    kenn4[2];
                short   not_used7;
                long    not_used8[35],
                        isf,            /* sampling rate in Hz          */
                        flagtype,       /* ILS: -32000 if sampling file
                                                -29000 if param. file   */
                        flaginit;       /* ILS: 32149 if init           */
                char    ifl[32],        /* filename (terminated by /0)  */
                        day,            /* # of day                     */
                        month;          /* # of month                   */
                short   year;           /* # of year                    */
                char    sex,            /* sex of speaker               */
                        version;        /* header version:
                                           0 = extended ILS
                                           1 = phondat version 1
                                           2 = phondat version 2        */
                short   adc_bits,       /* resolution of adc            */
                        words;          /* # of words in text           */
                long    not_useda[50];
                short   wdh,            /* # of repetition              */
                        abs_ampl;       /* maximum of amplitude         */
                char    not_usedb[10];
                } Phon_header_2;

/*
  icsiarg_t denotes the type of the variable which corresponds to the
  argument.
  */
typedef enum icsiarg_e 
{
  ARG_NOMOREARGS,
  ARG_DESC,
  ARG_INT,
  ARG_LONG,
  ARG_STR,
  ARG_BOOL,
  ARG_FLOAT,
  ARG_DOUBLE,
  ARG_NUMARGTYPES,
} icsiarg_t;

typedef enum icsiargr_e
{
   ARG_OPT,                                          /* argument is optional */
   ARG_REQ                                           /* argument is required */
} icsiargr_t;


typedef struct icsiargtab_s
{
  const char * argname;                              /* name of the argument */
  const char * argdesc;      /* text description of the arg (for usage info) */
  icsiarg_t    argtype;                              /* type of the argument */
  void        *varptr;            /* the variable which gets the arg's value */
  icsiargr_t   argreq;                          /* is the argument required? */
} icsiargtab_t;

/* #####################################################################*/

/* funktionsprototypen	(nach Modulen geordnet)				*/

/* ABSTAND		*/
double	cityblock(int dim,float *vek1,float *vek2,matrix *dummy);	
double	euklid(int dim,float *vek1,float *vek2,matrix *dummy);
double	geweuklid(int dim,float *vektor,float *mittel,matrix *invkov);
double	mahalanobis(int dim,float *vektor,float *mittel,matrix *invkov);

/* AUDIO		*/
short sparc10_audio(short *samples,long anz,long rate,double volume, 
               unsigned int port);                              
short sparc_audio(short *samples,long anz,long rate,double volume, 
               unsigned int port);
short sparc_audio_ulaw(unsigned char *samples,long anz,double volume,
               unsigned int port);
short sparc_audio_alaw(unsigned char *samples,long anz,double volume, 
               unsigned int port);

/* CLUSTER_UTI		*/
void clusterini(float **material,float *cb,int dim,int anz,float splitpar);
void readparamclusmain(FILE *fdef,float *splitpar,
			int *itermax,int *itermin,float *epsilon);
void clusterencode(float **material,float *cb,float *mintra,float *varintra,
		int *zaehler,float *cbh,int anz,int n,int dim,
		double (*dist)(int,float *,float *,matrix *));
int clusterupdate(int *zaehler,float **cb,float **cbh,
		int dim,int n,float splitpar);
float interset(float *cb,int anz,int dim,
		double (*dist)(int,float *,float *,matrix *),float *varinter);
void clustersplit(float *cb,int dim,int *n,float splitpar);
Stcb *readcodebook(char *cbfnam);
void writecodebook(char *cbfnam,Stcb *cb);
int writeasciicb(char *asciicbname,Stcb *cb);
float distorsion(float **material,int anz,Stcb *cb,
	double (*distanz)(int,float *,float *,matrix *));
void partition(Stcb *cb,float **daten,int anz,	
	double (*distanz)(int,float *,float *,matrix *),Stclus *clus);
void calkovar(Stclus *clus,Stcb *cb);
void kovarianzmat(int anz,int dim,float **part,float *mitt,matrix *kov);
void	delstcb(Stcb **cbptr);

/* DATA                  */
short *read_data_v2_vms(Phon_header_2 *header,int *samples,FILE *file);
short *read_data_v2_sun(Phon_header_2 *header,int *samples,FILE *file);
short *read_data_vms(Phon_header_2 *header,int *samples,FILE *file);
short *read_data_sun(Phon_header_2 *header,int *samples,FILE *file);

/* HEADER               */
Phon_header_2 *read_header_2_vms(FILE *phon_file,char **ortho,char **cano);
Phon_header_2 *read_header_2_sun(FILE *phon_file,char **ortho,char **cano);
Phon_header_2 *read_header_1_sun(FILE *phon_file);
Phon_header_2 *read_header_1_vms(FILE *phon_file);
Phon_header_2 *read_header_sun(FILE *phon_file,char **ortho,char **cano);
Phon_header_2 *read_header_vms(FILE *phon_file,char **ortho,char **cano);
int write_header_1_sun(FILE *phon_file,Phon_header_2 *header);
int write_header_1_vms(FILE *phon_file,Phon_header_2 *header);
int write_header_sun(FILE *phon_file,Phon_header_2 *header,char *ortho,
                     char *cano);
int write_header_vms(FILE *phon_file,Phon_header_2 *header,char *ortho,
                     char *cano);
void disp_header_v2(Phon_header_2 *header);
void longvms2sun(long *l);
void shortvms2sun(short *s);

/* ICSIARGS		*/
int icsiargs( icsiargtab_t *tab, int *argc, const char ***argv,
	     char **appname );
/*
  icsiargs is the main function you call to actually parse the arguments as
  given.  To use this function, you must first set up an argument
  descriptor table tab.  This table is a NULL-terminated array of elements of
  icsiargtab_t.  Each icsiargtab_t is a structure containing the following
  elements:
  const char *argname; the name of the argument, a string
  const char *argdesc; a textual description, of the arg, displayed as help
  icsiarg_t argtype;   the type of the argument, see below
  void *varptr;        a pointer to the variable which will contain the
                       specified value
  icsiargr_t argreq;   specifies if the argument is required or optional
                       (the default is for an argument to be optional)

  argtype can be one of
  ARG_INT, ARG_LONG, ARG_STR, ARG_BOOL, ARG_FLOAT, ARG_DOUBLE, or
  ARG_DESC.  ARG_DESC entries are dummy entries which you can
  use to supply more documentation in the usage message.  The current
  paradigm for ARG_BOOL is that the variable must be a C int, and if the
  value of a variable is specified as "1", "[tT].*" or "[yY].*", the
  variable will be set to TRUE, otherwise it will be set to false.
  for ARG_STR, the variable will be set to a malloced copy of the string
  specified on the command-line.
  argreq is one of ARG_REQ or ARG_OPT (note:  if you leave this out of a
  static initializer for the structure, ARG_OPT will be the default).  If it
  is ARG_REQ the argument will be required to be specified, if it is
  ARG_OPT, the argument is optional.
  
  icsiargs will parse the command-line, and will set the variables named in
  the argument table to the values specified on the command-line.  If
  appname is non-null, it will set the variable pointed to by appname to be
  a pointer to a malloced copy of the name which the application was called
  by.  It will modify argc and argv, eliminating the references to the
  arguments with "=" in them.  The remaining argc positional arguments will
  be left in the variable argv.  Note:  if somebody types a command of the
  form
  % command arg1=5 foo arg2=7
  icsiargs will set the variable referred to by arg1 to 5, and will set argc
  to 2 and argv to the array {"foo","arg2=7",NULL}

  icsiargs will return the number of arguments it successfully set.
  
  Author:  Jonathan Segal  jsegal@icsi.berkeley.edu
  */
void printargs( FILE *fp, const char *appname, const icsiargtab_t *argtab );
/*
  This function will print all the arguments and values as set to a given
  file (STDERR if fp is NULL).  This function will be useful for diagnostic
  output, e.g. to log files.   If appname is not null, it will display that,
  too.
*/

/* IOUTIL		*/
char *getwert(FILE *,char *);
void disp_float2(float *,int,int);
void disp_short2(short *,int,int);
void disp_int2(int *frame,int nn,int dim);
int iolog(int log);
void get_string(char *output,char *string);

/* LABEL		*/
int labgetipsk(char *satz,long sample,int ipsk[]);
char *labgetsilbos(char *satz,long sample);
int labgetsamples(char *satz,int ipsk,long **samples);
char *labmapipsktosilbos(int n,int ipsk[]);
int labipskdiacrit(int ipsk);
int labipskdummy(int ipsk);
int labipskerror(int ipsk);
char *labipsktosilbos(int ipsk);
char *labipskgrouptosilbos(int n,int phonem[]);
Label *labtransipsktosilbos(char *satz);
int labgetword(char *satz,char *word,long **samples);
void labgetsatz(char *satz,int *begin,int *end);
int labgetphonem(char *satz,char *phonem,long **samples);

/* LINUXAUDIO		*/
int linux_audio(short int *buf,int len, int type, int rate, float volume);
short int ulaw2linear(unsigned char u_val);
short int alaw2linear(unsigned char a_val);

/* MATRIX		*/
matrix * genmat (long,long) ;
matrix * getmat (long,long) ;
int writemat (FILE * , matrix *) ;
int ascwmat (FILE * , matrix *) ;
matrix * readmat (FILE * ) ;
matrix * ascrmat (FILE * ) ;
void prmat (matrix *) ;
void delmat (matrix **) ;
int gau (matrix *,matrix *) ;
int invdet (matrix *, matrix *, double *) ;

/* PREPROCESS */
void windw (short n,float *x,float *h,long *flg);
void preem(short n,float *x,float *x_pre,float pre);
void autom(short n,float *x,short m,float *a,float *alpha,float *rc,float *r);
void a2cep(float *sa,short m,float *cep);

/* STATISTIK		*/
void staregress( double *px , double *py , int laenge ,double *r,double *b, 
		double *c);

/* STROP */
void	samlabel_zu_vaxvms_dname(char *s);

/* TIEFPASS		*/
void tiefpass(float *signal,int frameanz,int faktor);

/* VEKMATH		*/
void reset_float2(float *feld,int dim1,int dim2);
void reset_int2(int *feld,int dim1,int dim2);
void float2_div_float(float *divisor,float dividend,
	float *div,int dim1,int dim2);
void float2_div_int1(float *divisor,int *dividend,float *div,
	int dim1,int dim2);
void float2_add_float2(float *sum1,float *sum2,float *sum,
	int dim1,int dim2);
void float2_sub_float2(float *sub1,float *sub2,float *erg,
	int dim1,int dim2);
double betrag_float(float *vektor,int dim);
int recmittel_float(int dim,float *mittel,int c,float *vektor);
	float max_float2(float *feld,int dim1,int dim2);
	float min_float2(float *feld,int dim1,int dim2);
void norm_float2(float *feld,int dim1,int dim2,float norm);

#ifdef __cplusplus
}
#endif


#endif
