//******************************** -*-c++-*- ********************************
//
// Headerfile: CwordVar.h
//
// Autor: A. Kipp
// erstellt: Fri Dec 6 13:59:41 MET 1996
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef __CwordVar__
#define __CwordVar__
#include "Cvargraph.h"
#include "Cmlf.h"

#define NULLNODESYM "!NULL"
#define JOKERSYM "**"
struct rule
{
  int rulenr;
  
  double ruleweight;
  double cellwk;
  
  int inident;
  int endident;
  int lsanz;
  char** ls;
  int rsanz;
  char** rs;
  
  void verbatim(char* target)
  {
    int i;
    char* cp=target;
    for(i=0 ; i<lsanz ; i++ )
      {
	sprintf(cp,"%s",ls[i]);
	cp+=strlen(ls[i]);
      }
    sprintf(cp++,">");
    for(i=0 ; i<rsanz ; i++ )
      {
	sprintf(cp,"%s",rs[i]);
	cp+=strlen(rs[i]);
      }
  };

  static rule* createRegel(char* str,char** inv,int anzinv);
};

class Cvgrnode;
struct vtrnoderec;

struct ruleappl
{
  ruleappl() { rentry = rexit = NULL; csplit = -1;};
  rule* therule;
  int sind;
  int eind;
  int csplit;
  int crecom;

  Cvgrnode* rentry;
  Cvgrnode* rexit;

  double rapwk;
};

struct vtrnoderec
{
  vtrnoderec() { nullnode=NULL;};
  Cvgrnode* vgrndp;
  Cverklist<ruleappl*> rappls;
  ruleappl** rp;
  int rpanz;
  Cverklist<ruleappl*> rapplstarts;
  ruleappl** rps;
  int rpsanz;

  Cvgrnode* nullnode;
};

 

//***************************************************************************
// Klassendeklaration: class CwordVar
//
// Autor: A. Kipp
// erstellt: Fri Dec 6 13:59:41 MET 1996
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
class CwordVar
{
  public:
  CwordVar();
  virtual int readRegeln(char* regelfilename);
  virtual void applyRules();
  void firstPass( ruleappl* rap );
  void scoreEdges();
  void setWordnums();
  void run();
  void setIn(FILE* fp) { mlf->setIn(fp);};
  void setOut(FILE* fp) { vargraph->setOut(fp);};
  void openGraphOutfile();
  void mlf2vargraph();
  int sameContext(ruleappl* r1,ruleappl* r2);
  void insMonoBack();
  void writeHead();

  Cvargraph* vargraph;
  Cmlf* mlf;
  double jumpwk;
  double monoback;
  int jokers;
  char* workdir;
  
  protected:
  Cnode **ndlist;
  vtrnoderec *vtrrecndlist;
  ruleappl** allrap;
  int allrapanz;
  int ndanz;
  int vtrndanz;
  
  rule** regellist;
  int regelanz;

};

#endif
