
/**************************************************************************
***************************************************************************

Modul           : abstand.c
Directory       : vb$dua1:[sch.lib]
Titel           : abstandsberechnungen

Autor           : F. Schiel
Datum/Aenderung : 25.11.90 / 05.04.91

Beschreibung:

Anzulinkende Module	:

Subroutinen:
cityblock		: berechnung des city-block-abstands zweier vek.
euklid			: berechnet den quadr. euklid. abstand zweier vektoren
geweuklid		: berechnet den varianz-gewichteten euklid. abstand
mahalanobis		: berechnet den mahalanobis-abstand

*/
# include <math.h>
# include <stdio.h>
# include "ipkclib.h"

# define MAXKOMP 20	/* maximale anzahl von komponenten eines vektors*/


/*------------------------------------------------------------------------

Name            : cityblock
Modul           : abstand.c
Titel           : berechnung des city-block-abstands zweier vektoren

Beschreibung:
liefert den city-block-abstand (betragsabstand) zweier float-vektoren 
beliebiger dimension (dim).

	x = summe |vek1(i) - vek2(i)|
	      i
 
Parameter:
dim		: dimension der vektoren
vek1		: pointer auf vektor 1
vek2		: pointer auf vektor 2
dummy		: noch nicht benutzt

Return-Value	: cityblock-abstand x
*/
double	cityblock(int dim,float *vek1,float *vek2,matrix *dummy)
{ 
	register int i;

	double 	d;

	d = 0.;
	for(i=0; i<dim; i++)
		d += fabs(*(vek1++) - *(vek2++));
	return(d);
}

/*----------------------------------------------------------------------

Name            : euklid
Modul           : abstand.c
Titel           : berechnung des euklid-abstands zweier vektoren

Beschreibung:
berechnet den quadratischen euklidschen abstand zweier vektoren der 
dimension dim (mean square error):

	x = summe (vek1(i) - vek2(i))^2
	      i
 
Parameter:
dim		: dimension der vektoren
vek1		: pointer auf vektor 1
vek2		: pointer auf vektor 2
dummy		: noch nicht benutzt

Return-Value	: quadrat. euklid-abstand x
*/
double	euklid(int dim,float *vek1,float *vek2,matrix *dummy)
{ 
	register int i;

	float 	d,q;

	q = 0.;
	for(i=0; i<dim; i++)
	{
		d = *(vek1++) - *(vek2++);
		q += d*d;
	}
	return((double)q);
}

/*-------------------------------------------------------------------------

Name            : geweuklid
Modul           : abstand.c
Titel           : berechnet den varianz-gewichteten euklid. abstand

Beschreibung:
berechnet den mit den varianzen der einzelnen komponenten gewichteten 
euklidschen abstand zweier vektoren der dimension dim.

	x = (vektor - mittel)' 1/diag(kovar) (vektor - mittel)

die gewichte sind dabei die inversen diagonal-elemente der kovarianzmatrix, 
d.h. die inversen der quadrat. varianzen der einzelnen komponenten. eine 
komponente mit kleiner varianz wird somit hochgewichtet, eine solche mit
grosser varianz entsprechend klein gewichtet.
die gewichte 1/diag(kovar) werden statt der inv. kovarianzmatrix (matrix.h) 
in einem float-vektor uebergeben. 
 
Parameter:
dim		: dimension der vektoren
vektor		: pointer auf unbekannten vektor
mittel		: pointer auf mittelwertsvektor
gewichte	: pointer auf array von float-werten, auf pointer auf 
		  matrix (matrix.h) gecastet.
Return-Value	: gew. euklid-abstand 

*/
double	geweuklid(int dim,float *vektor,float *mittel,matrix *gewichte)
{
	register int	k;
	float	*hgew;
	float	d,e;

/* initialisierung							*/
    d = 0.;
    hgew = (float *) gewichte;
    
/* gew. euklid berechnen:						*/
    for(k=0; k<dim; k++)
    {
	e = *(vektor++) - *(mittel++);
	d += e * e * *(hgew++);
    }

    return((double)d);
} /* ende subroutine geweuklid						*/


/*-----------------------------------------------------------------------

Name            : mahalanobis
Modul           : abstand.c
Titel           : berechnet den mahalanobis-abstand

Beschreibung:
berechnet den mahalanobis-abstand zweier vektoren der dimension dim.

	x = (vektor - mittel)' invkovar (vektor - mittel)

die inverse kovarianzmatrix wird in einer struktur matrix (matrix.h) zur 
verfuegung gestellt. da die zeilen der matrix infolge der invertierung 
nicht mehr unbedingt hintereinander im speicher liegen muessen, wird mit 
voller indizierung ueber das pointerarray der zeilen gearbeitet. die 
inversen kovarianz-matrizen liegen normalerweise nicht in den orginal-
werten vor, da sonst eine berechnung der determinante im float-bereich der
VAX nicht moeglich ist. die vektoren muessten daher entweder vorher mit dem
faktor cb->detnorm oder der return-wert mit dem faktor cb->detnorm^2
multipliziert werden. beachte, dass das ergebnis dann nicht der echte
mahalanobis-abstand der orginal-vektoren, sondern der mahalanobi-abstand
von vektoren multipliziert mit cb->detnorm ist. dieses ergebnis kann jedoch
ohne weitere normierung direkt in die formel fuer die multi-variate
gausswahrscheinlichkeit eingesetzt werden, wenn dabei ein ebenso normierter
wert fuer die determinate der kovarianzmatrix verwendet wird.
 
Parameter:
dim		: dimension der vektoren
vektor		: pointer auf unbekannten vektor
mittel		: pointer auf mittelwertsvektor
invkovar	: pointer auf inverse kovarianz-matrix (matrix.h)

Return-Value	: - mahalanobis-abstand von normierten vektoren, wenn vor
		    dem aufruf sowohl vektor als auch mittel mit cb->detnorm 
		    multipliziert wurden oder 
		  - mahalanobis-abstand/cb->detnorm^2 bei orginal-vektoren 
		    und -prototypen

*/
double	mahalanobis(int dim,float *vektor,float *mittel,matrix *invkov)
{
	register int	i,k;
	float	d,d1,
		a[MAXKOMP],	/* vektor fuer zwischenergebnisse	*/
		*ha;
	double	*zptr;		/* hilfspointer auf zeile der invkov	*/

/* initialisierung							*/
    d = 0.;
    
/* differenzvektor berechnen 						*/
    ha = a;
    for(i=0; i<dim; i++)
	*(ha++) = *(vektor++) - *(mittel++);

/* mahalanobis berechnen:						*/
    for(k=0; k<dim; k++)
    {
/* hilfspointer zptr auf ersten zeilenpointer setzen			*/
	zptr = invkov->m[k];
/* erste zeile mit differenzvektor a multiplizieren -> d1		*/
	d1 = 0.;
	ha = a;
	for(i=0; i<dim; i++)
	    d1 += (float)*(zptr++) * *(ha++);

/* d1 mit k-ter komponente von differenzvektor multiplizieren und summieren*/
	d += a[k] * d1;
    }

    return((double)d);

} /* ende subroutine mahalanobis					*/
