//****************************************************************************
//
// CCfile: Chgraph.cc
//
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "Chgraph.h"
#include "CCexceptions.h"
#include <stdlib.h>

extern "C" {
#include "gen_lexvar-1.0.h"
}

#define READ_FILENAME 0
#define READ_ORTHO 1
#define READ_NODES 2
#define READ_EDGES 3

//***************************************************************************
// Implementierung der Klasse: Chgraph
// Autor: A. Kipp
// erstellt: Tue Mar 28 13:57:00 1995 
// veraendert:
//***************************************************************************
Chgraph::Chgraph()
  {
  inventar = NULL;
  anzinv = 0;
  ortho = NULL;
  }
  
  
////////////////////////////////////////////////////////////////////////////////
//
// Funktion: Chgraph::readHypGraph
//
// Parameter: void
//
// Beschreibung: Liest den Graph ein
// und baut ihn auf.  
////////////////////////////////////////////////////////////////////////////////
int Chgraph::readHGraph() 
  {
  int state = READ_FILENAME,i,nc,nodenr,startnode,endnode,rulenumber;
  char line[MAXLINELEN],symb[50],/*addata[MAXLINELEN],*/*cp;
  Cnode* knp;
  Cedge* edp;
  
  clear();
  
  while( fgets(line,MAXLINELEN,in) != NULL )
    {
    if( line[0] == '\n' )
      {
      continue;
      }
    if( !strncmp(line,"//",2) )
      {
      continue;
      }
      
    switch(state)
      {
      case READ_FILENAME :
        filename=strdup(line);
        cp = strchr(filename,'\n');
        if( cp != NULL )
          {
          *cp='\0';
          }
        state=READ_ORTHO;
        break;
      case READ_ORTHO:
        ortho=strdup(line);
        if( ortho == NULL )
          {
          failure(__FILE__,__LINE__,"Out of Memory");
          }
        //entferne newline
        cp=strchr(ortho,'\n');
        if( cp != NULL )
          {
          *cp='\0';
          }  
        state=READ_NODES;
      break;
      
      case READ_NODES:
        //addata=NULL;
        if( line[0] == VOR_KANTEN )
          {
          state=READ_EDGES;
          }
        else if( sscanf(line,KNOT_MASK_R,&nodenr,symb,&nc) >= 2 )
          {
          knp=newNode();
          knp->nodenr=nodenr;
          ((Chgrnode*)knp)->addata=strdup(line+nc);
          //entferne newline
          cp=strchr(((Chgrnode*)knp)->addata,'\n');
          if( cp != NULL )
            {
            *cp='\0';
            }
          for( i=0 ; i<anzinv ; i++ )
            {
            if( !strcmp(inventar[i],symb) )
              {
              ((Chgrnode*)knp)->symbol = inventar[i];
              addNode(knp);
              break;
              }
            }
          if( i==anzinv )
            {
            return INVALID_SYMB;
            }
          }
        else
          {
          return VARGRAPH_ERRNODES;
          }
      break;
      
      case READ_EDGES:
        //addata=NULL;
        if( line[0] == VOR_NEXTORTHO )
          {
          return nodes.getAnzel();
          }
        else if( sscanf(line,KANT_MASK_R,&startnode,&endnode,
                        &rulenumber,&nc) >= 3 )
          {
          edp=newEdge();
          ((Chgredge*)edp)->startnode = getNodeNr(startnode);
          ((Chgredge*)edp)->endnode = getNodeNr(endnode);
          ((Chgredge*)edp)->rulenumber=rulenumber;
          ((Chgredge*)edp)->addata=strdup(line+nc);
          //entferne newline
          cp=strchr(((Chgredge*)edp)->addata,'\n');
          if( cp != NULL )
            {
            *cp='\0';
            }
          addEdge(edp);
          }
        else
          {
          return VARGRAPH_ERREDGES;
          }
      break;
      }
    }
    
  // fileende
  return EOF;
  }

void Chgraph::writeHGraph()
  {
  int i;
  char* cp;
  Cnode **ndptrptr;
  Cedge **edptrptr;
  
  fprintf(out,"%s\n",filename);
  fprintf(out,"%s\n",ortho);
  
  for( ndptrptr=nodes.skipThru(init) ; ndptrptr != NULL ; 
         ndptrptr=nodes.skipThru(next) )
    {
    fprintf(out,KNOT_MASK_W,
            (*ndptrptr)->nodenr,
            ((Chgrnode*)(*ndptrptr))->symbol, //don't worry be happy
            ((Chgrnode*)(*ndptrptr))->addata == NULL ? 
            "" : ((Chgrnode*)(*ndptrptr))->addata);
    }
    
  fputc(VOR_KANTEN,out);
  fputc('\n',out);
  
  for(edptrptr=edges.skipThru(init) ; edptrptr!=NULL ;
       edptrptr=edges.skipThru(next) )
    {
    fprintf(out,KANT_MASK_W,
    ((Chgredge*)(*edptrptr))->startnode->nodenr,
    ((Chgredge*)(*edptrptr))->endnode->nodenr,
    ((Chgredge*)(*edptrptr))->rulenumber,
    ((Chgredge*)(*edptrptr))->addata == NULL ? "" : 
    ((Chgredge*)(*edptrptr))->addata);
    }
    
  fputc(VOR_NEXTORTHO,out);
  fputc('\n',out);
  fflush(out);
  }
 
int Chgraph::readInventar(char* filename)
  {
  FILE* fp;
  Cverklist<char*> v_invlist;
  char* cp;
  char line[100];
  
  if( (fp = fopen(filename,"r")) == NULL)
    {
    return -1 ;
    }
  
  while( fgets(line,100,fp) != NULL )
    {
    if( sscanf(line,"%s",line) == 1 )
      {
      cp = strdup(line);
      }
    v_invlist.addEl(&cp);
    }
    
  anzinv=v_invlist.compact(&inventar);
  return anzinv;
  } 

int Chgraph::getNodeInfo(Cnode* ndptr,char* info)
  {
  char* cp;
  char symb[20];
  int i;
  
  sscanf(info,"%s",symb);

  for( i=0 ; i<anzinv ; i++ )
    {
    if( !strcmp(inventar[i],symb) )
      {
      ((Chgrnode*)ndptr)->symbol = inventar[i];
      break;
      }
    }
  if( i==anzinv )
    {
    return INVALID_SYMB;
    }
    
  return 1;
  }
  
void Chgraph::putNodeInfo(Cnode* ndptr,FILE* fp)
  {
  fprintf(fp," %s",((Chgrnode*)ndptr)->symbol);
  }
  
int Chgraph::getEdgeInfo(Cedge* edptr,char* info)
  {
  return sscanf(info,"%d %lf",&((Chgredge*)edptr)->rulenumber,
                &((Chgredge*)edptr)->weight);
  }
  
void Chgraph::putEdgeInfo(Cedge* edptr,FILE* fp)
  {
  fprintf(fp," %d %le",((Chgredge*)edptr)->rulenumber,
                ((Chgredge*)edptr)->weight);
  }

void Chgraph::clear()
  {
  free(ortho);
  free(filename);
  
  Cgraph::clear();
  }
  
Chgraph::~Chgraph()
  {
  int i;
  
  clear();
  
  for( i=0 ; i<anzinv ; i++ )
    {
    free(inventar[i]);
    }
    
  delete [] inventar;
  }
