//****************************************************************************
//
// CCfile: Cdocsys.cc
//
// Autor: A. Kipp
// erstellt: Wed Sep 27 16:14:47 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include "Cdocsys.h"

//***************************************************************************
// Implementierung der Klasse: Cdocsys
// Autor: A. Kipp
// erstellt: Wed Sep 27 16:14:47 1995 
// veraendert:
//***************************************************************************
Cdocsys::Cdocsys(char* dsm)
  {
  docsysmark = strdup(dsm);
  }
  
void Cdocsys::pipeInfo(FILE* fp,FILE* fpout)
  {
  char line[300];
  int i;
  
  while( fgets(line,300,fp) != NULL )
    {
    if( strncmp(line,docsysmark,strlen(docsysmark)) )
      {
      break;
      }
    fprintf(fpout,"%s>%s",docsysmark,line+strlen(docsysmark));
    }
    
  for( i=strlen(line)-1; i>=0 ; i-- )
    {
    ungetc(line[i],fp);
    }
  }
  
void Cdocsys::writeInfo(FILE* fpout,icsiargtab_t* args,
                       char* appname,char* version)
  {
  int i;
  time_t datum;
  
  time(&datum);
  fprintf(fpout,"%s %s %s\n",docsysmark,appname,version);
  fprintf(fpout,"%s invoked at %s",docsysmark,ctime(&datum));
  fprintf(fpout,"%s with arguments:\n",docsysmark);
  
  for(i=0 ; args[i].argname != 0 ; i++ )
    {
    switch( args[i].argtype )
      {
      case ARG_STR:
          fprintf(fpout,"%s %s : %s\n",
          docsysmark,args[i].argdesc,
          *((char**)(args[i].varptr)) == NULL ? "NULL" : *((char**)(args[i].varptr)));
          break;
      case ARG_DOUBLE :
          fprintf(fpout,"%s %s : %lf\n",
          docsysmark,args[i].argdesc,*((double**)(args[i].varptr)));
          break;
      case ARG_INT :
          fprintf(fpout,"%s %s : %lf\n",
          docsysmark,args[i].argdesc,*((int**)(args[i].varptr)));
          break;
      case ARG_BOOL :
          fprintf(fpout,"%s %s : %s\n",
          docsysmark,args[i].argdesc,*((int**)(args[i].varptr))>0 ? "true" :
          "false");
          break;
      default:
          break;
      }
    }  
  }
  
  
