
# 2019-03-22 : if a word link number '-1' appears in word link list,
#              the link is ignored (can happen at the very first NOI)

BEGIN { first_idx = EMUID 
        idx = EMUID }
{ 
  # this script gets filtered BPF class 1 tiers with multiple word links!
  if($2=="-1") {
    # free-floating item : link to bundle, but no link to class 1
    class1idx[idx] = ""
  }
  else {
    class1idx[idx] = $2
  }
  idx ++
}
END {
  for(i=first_idx;i<idx;i++) {
    # print link from bundle to item
    printf("        {\n            \"fromID\": 0,\n            \"toID\": %d\n        }",i)
    nc = split(class1idx[i],carr,/[,;]/)
    for(j=1;j<=nc;j++) {
      # print link to class 1 item(s)
      # BPF links start with 0, but class 1 level starts with 1!
      # ignore word link '-1', if it appears in word link list
      if(carr[j] != -1) printf(",\n        {\n            \"fromID\": %d,\n            \"toID\": %d\n        }",i,carr[j]+1)
    }
    if( i<idx-1 ) printf(",\n")
  }
}
